/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates;

import java.security.cert.X509Certificate;
import org.openide.util.Lookup;

public abstract class CertificateTrustHandler {
    public static final String PROP_CERT_CHAIN_HANDLED = "certificateChainHandled";
    private static CertificateTrustHandler _default;

    public static synchronized CertificateTrustHandler getDefault() {
        if (_default == null && (_default = (CertificateTrustHandler)Lookup.getDefault().lookup(CertificateTrustHandler.class)) == null) {
            throw new IllegalStateException("Failed to find Certificate Trust Handler");
        }
        return _default;
    }

    public abstract TrustResult handleCertificate(String var1, X509Certificate[] var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public abstract CertificateActions mustShowTrustPrompt(X509Certificate var1, String var2, boolean var3);

    public boolean mustShowTrustPrompt(CertificateActions action) {
        return action == CertificateActions.SHOW_STORE || action == CertificateActions.SHOW_STORE_ATTACH_HOSTNAME || action == CertificateActions.SHOW_ATTACH_HOSTNAME;
    }

    public static enum CertificateActions {
        ALLOW,
        BLOCK,
        SHOW_STORE,
        SHOW_STORE_ATTACH_HOSTNAME,
        SHOW_ATTACH_HOSTNAME,
        DATE_INVALID,
        BLACKLISTED;

    }

    public static enum TrustResult {
        TRUST,
        DONT_TRUST,
        CANCEL,
        STILL_TO_CHOOSE;

    }
}

