/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageContainer;
import com.paterva.maltego.imgfactory.impl.ImageDiskCache;
import com.paterva.maltego.imgfactory.impl.ImageID;
import com.paterva.maltego.imgfactory.impl.ImageMemoryCache;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

class SwappingImageCache
extends TimerTask
implements ImageContainer {
    private final ImageMemoryCache _memoryCache;
    private final ImageDiskCache _diskCache;
    private final Object _cacheLock = new Object();
    private final int _maxMemoryIdleTime;
    private final int _maxMemoryImages;
    private final Timer _shrinkTimer;
    private int _debugGetMem = 0;
    private int _debugGetDisk = 0;
    private int _debugPut = 0;
    private int _debugPopped = 0;

    public SwappingImageCache(int memoryShrinkInterval, int maxMemoryIdleTime, int maxMemoryImages) {
        this._maxMemoryIdleTime = maxMemoryIdleTime;
        this._maxMemoryImages = maxMemoryImages;
        this._memoryCache = new ImageMemoryCache();
        this._diskCache = new ImageDiskCache();
        this._shrinkTimer = new Timer();
        this._shrinkTimer.scheduleAtFixedRate((TimerTask)this, memoryShrinkInterval, (long)memoryShrinkInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(ImageID imageId) {
        Object object = this._cacheLock;
        synchronized (object) {
            if (this._memoryCache.contains(imageId)) {
                return true;
            }
            if (this._diskCache.contains(imageId)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image get(ImageID imageId) {
        Object object = this._cacheLock;
        synchronized (object) {
            if (this._memoryCache.contains(imageId)) {
                ++this._debugGetMem;
                return this._memoryCache.get(imageId);
            }
            ++this._debugGetDisk;
            Image image = this._diskCache.get(imageId);
            this.popAndPut(imageId, image);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ImageID imageId, Image image) {
        Object object = this._cacheLock;
        synchronized (object) {
            ++this._debugPut;
            this.popAndPut(imageId, image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ImageID imageId, boolean anySizes) {
        Object object = this._cacheLock;
        synchronized (object) {
            this._memoryCache.remove(imageId, anySizes);
            this._diskCache.remove(imageId, anySizes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._memoryCache.clear();
            this._diskCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._cacheLock;
        synchronized (object) {
            return this._memoryCache.size() + this._diskCache.size();
        }
    }

    private void popAndPut(ImageID imageId, Image image) {
        while (this._memoryCache.size() > this._maxMemoryImages - 1) {
            ++this._debugPopped;
            this.moveOldestToDisk();
        }
        this._memoryCache.put(imageId, image);
    }

    private void moveOldestToDisk() {
        ImageID oldestID = this._memoryCache.getOldest();
        if (!this._diskCache.contains(oldestID)) {
            Image oldestIcon = this._memoryCache.get(oldestID);
            this._diskCache.put(oldestID, oldestIcon);
        }
        this._memoryCache.remove(oldestID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkMemoryCache() {
        Date now = new Date();
        Date latestValidTime = new Date(now.getTime() - (long)this._maxMemoryIdleTime);
        ArrayList<ImageID> relocateImageIds = new ArrayList<ImageID>();
        ArrayList<Image> relocateImages = new ArrayList<Image>();
        Object object = this._cacheLock;
        synchronized (object) {
            this._memoryCache.removeOlderThan(latestValidTime, relocateImageIds, relocateImages);
            for (int imageNum = 0; imageNum < relocateImageIds.size(); ++imageNum) {
                ImageID imageId = relocateImageIds.get(imageNum);
                if (this._diskCache.contains(imageId)) continue;
                this._diskCache.put(imageId, relocateImages.get(imageNum));
            }
        }
    }

    @Override
    public void run() {
        this.shrinkMemoryCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        Object object = this._cacheLock;
        synchronized (object) {
            sb.append("GetMem:");
            sb.append(this._debugGetMem);
            sb.append(" GetDisk:");
            sb.append(this._debugGetDisk);
            sb.append(" Put:");
            sb.append(this._debugPut);
            sb.append(" Popped:");
            sb.append(this._debugPopped);
            sb.append("\n");
            sb.append(this._memoryCache.getStatus());
            sb.append(this._diskCache.getStatus());
            this._debugGetMem = 0;
            this._debugGetDisk = 0;
            this._debugPut = 0;
            this._debugPopped = 0;
        }
        return sb.toString();
    }
}

