/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.MtzVersion;
import java.io.File;
import java.util.ArrayList;

public enum GraphFileType {
    GRAPHML("mtgx", "Maltego Graph (old format)", MtzVersion.getMTGX()),
    PANDORA("mtgl", "Maltego Graph", MtzVersion.getCurrent());

    private final String _ext;
    private final String _description;
    private final MtzVersion _mtzVersion;

    private GraphFileType(String ext, String description, MtzVersion mtzVersion) {
        this._ext = ext;
        this._description = description;
        this._mtzVersion = mtzVersion;
    }

    public String getExtension() {
        return this._ext;
    }

    public String getDescription() {
        return this._description;
    }

    public String toString() {
        return this._ext;
    }

    public MtzVersion getMtzVersion() {
        return this._mtzVersion;
    }

    public static GraphFileType getDefaultType() {
        return PANDORA;
    }

    public static GraphFileType forFile(File file) {
        return GraphFileType.forFile(file.getName());
    }

    public static GraphFileType forFile(String filenameOrPath) {
        for (GraphFileType fileType : GraphFileType.values()) {
            if (!filenameOrPath.toLowerCase().endsWith("." + fileType.getExtension().toLowerCase())) continue;
            return fileType;
        }
        return GraphFileType.getDefaultType();
    }

    public static GraphFileType forExtension(String ext) {
        for (GraphFileType fileType : GraphFileType.values()) {
            if (!fileType.getExtension().equalsIgnoreCase(ext)) continue;
            return fileType;
        }
        return GraphFileType.getDefaultType();
    }

    public static String[] getAllExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (GraphFileType fileType : GraphFileType.values()) {
            extensions.add(fileType.getExtension());
        }
        return extensions.toArray(new String[extensions.size()]);
    }
}

