/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.find.files.actions.SelectNodesAction;
import com.paterva.maltego.find.files.nodes.PropertyUtils;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.nodes.EntityProperties;
import java.awt.Image;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FoundEntityNode
extends AbstractNode {
    private MaltegoEntity _entity;
    private String _snippet;

    public FoundEntityNode(MaltegoEntity entity, String snippet) {
        this(entity, snippet, new InstanceContent());
    }

    public FoundEntityNode(MaltegoEntity entity, String snippet, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._entity = entity;
        this._snippet = snippet;
        content.add((Object)this._entity);
        content.add((Object)this);
        MaltegoEntitySpec spec = this.getEntitySpec();
        if (spec != null) {
            content.add((Object)spec);
        }
        EntityRegistry registry = EntityRegistry.getDefault();
        String name = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)this._entity);
        this.setDisplayName(name);
        this.setShortDescription(snippet);
    }

    public Image getIcon(int type) {
        return EntityImageFactory.getDefault().getImage(this._entity, -1, this.getSize(type), null);
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }

    protected Sheet createSheet() {
        Sheet sheet = EntityProperties.createSheetNoLinkInfo((Node)this, (MaltegoEntity)this._entity, (MaltegoEntitySpec)this.getEntitySpec());
        PropertyUtils.addPartFindProperties(sheet, (Node)this, this._snippet);
        return sheet;
    }

    private MaltegoEntitySpec getEntitySpec() {
        EntityRegistry registry = EntityRegistry.getDefault();
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(this._entity.getTypeName());
        return spec;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(SelectNodesAction.class)};
    }

    public Action getPreferredAction() {
        return SystemAction.get(SelectNodesAction.class);
    }
}

