/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.settings;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class HubSeedSettingsNode
extends AbstractNode {
    private final HubSeedDescriptor _hubSeed;
    private final DisplayDescriptorCollection _properties;

    public HubSeedSettingsNode(HubSeedDescriptor hubSeed, DisplayDescriptorCollection properties) {
        super(Children.LEAF);
        this._hubSeed = hubSeed;
        this._properties = properties;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        HubSeedSettings settings = HubSeedSettings.getDefault();
        DataSource globalTxSettings = settings.getGlobalTransformSettings(this._hubSeed);
        Sheet.Set inputs = PropertySheetFactory.getSet((Sheet)sheet, (String)"inputs", (String)"Transform Inputs", (String)"Transform inputs are user parameters that are sent to all the transform of this seed to control their behaviour.");
        if (this._properties != null) {
            for (DisplayDescriptor dd : this._properties) {
                try {
                    DisplayDescriptorProxy ddProxy = new DisplayDescriptorProxy((TransformPropertyDescriptor)dd);
                    PropertySheetFactory.getDefault().addProperty(sheet, (DisplayDescriptor)ddProxy, globalTxSettings, null, inputs);
                }
                catch (UnsupportedEditorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return sheet;
    }

    private class DisplayDescriptorProxy
    extends TransformPropertyDescriptor {
        public DisplayDescriptorProxy(TransformPropertyDescriptor descriptor) {
            super(descriptor);
        }

        public String getImage() {
            if (this.isInternal()) {
                return "com/paterva/maltego/transform/manager/resources/Internal.gif";
            }
            if (this.isPopup() && this.isAuth()) {
                return "com/paterva/maltego/transform/manager/resources/PopupKey.png";
            }
            if (this.isPopup()) {
                return "com/paterva/maltego/transform/manager/resources/Popup.gif";
            }
            if (this.isAuth()) {
                return "com/paterva/maltego/transform/manager/resources/Key.png";
            }
            return super.getImage();
        }
    }
}

