/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.structure;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.structure.CollectionMods;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GraphStructureMods {
    private Set<EntityID> _entitiesAdded = new HashSet<EntityID>();
    private Set<EntityID> _entitiesRemoved = new HashSet<EntityID>();
    private Map<EntityID, CollectionMods> _collectionMods = new HashMap<EntityID, CollectionMods>();
    private Set<EntityID> _entitiesPinned = new HashSet<EntityID>();
    private Set<EntityID> _entitiesUnpinned = new HashSet<EntityID>();
    private Set<LinkID> _linksAdded = new HashSet<LinkID>();
    private Map<LinkID, LinkEntityIDs> _linksRemoved = new HashMap<LinkID, LinkEntityIDs>();
    private boolean _layoutNew = false;

    public static GraphStructureMods weakCopy(GraphStructureMods graphStructureMods) {
        GraphStructureMods gsm = new GraphStructureMods();
        gsm._entitiesAdded.addAll(graphStructureMods._entitiesAdded);
        gsm._entitiesRemoved.addAll(graphStructureMods._entitiesRemoved);
        gsm._collectionMods.putAll(graphStructureMods._collectionMods);
        gsm._entitiesPinned.addAll(graphStructureMods._entitiesPinned);
        gsm._entitiesUnpinned.addAll(graphStructureMods._entitiesUnpinned);
        gsm._linksAdded.addAll(graphStructureMods._linksAdded);
        gsm._linksRemoved.putAll(graphStructureMods._linksRemoved);
        gsm._layoutNew = graphStructureMods._layoutNew;
        return gsm;
    }

    public static synchronized GraphStructureMods create(Set<EntityID> entitiesBefore, Set<EntityID> entitiesAfter, Map<LinkID, LinkEntityIDs> linksBefore, Map<LinkID, LinkEntityIDs> linksAfter) {
        GraphStructureMods mods = new GraphStructureMods();
        Set<EntityID> entitiesAdded = mods.getEntitiesAdded();
        Set<EntityID> entitiesRemoved = mods.getEntitiesRemoved();
        Set<LinkID> linksAdded = mods.getLinksAdded();
        Map<LinkID, LinkEntityIDs> linksRemoved = mods.getLinksRemoved();
        entitiesAdded.addAll(entitiesAfter);
        entitiesAdded.removeAll(entitiesBefore);
        entitiesRemoved.addAll(entitiesBefore);
        entitiesRemoved.removeAll(entitiesAfter);
        linksAdded.addAll(linksAfter.keySet());
        linksAdded.removeAll(linksBefore.keySet());
        linksRemoved.putAll(linksBefore);
        linksRemoved.keySet().removeAll(linksAfter.keySet());
        return mods;
    }

    public boolean isEmpty() {
        return this._entitiesAdded.isEmpty() && this._entitiesRemoved.isEmpty() && this._collectionMods.isEmpty() && this._linksAdded.isEmpty() && this._linksRemoved.isEmpty() && this._entitiesPinned.isEmpty() && this._entitiesUnpinned.isEmpty();
    }

    public Set<EntityID> getEntitiesAdded() {
        return this._entitiesAdded;
    }

    public Set<EntityID> getEntitiesRemoved() {
        return this._entitiesRemoved;
    }

    public Map<EntityID, CollectionMods> getCollectionMods() {
        return this._collectionMods;
    }

    public Set<EntityID> getEntitiesPinned() {
        return this._entitiesPinned;
    }

    public Set<EntityID> getEntitiesUnpinned() {
        return this._entitiesUnpinned;
    }

    public Set<LinkID> getLinksAdded() {
        return this._linksAdded;
    }

    public Map<LinkID, LinkEntityIDs> getLinksRemoved() {
        return this._linksRemoved;
    }

    public boolean isLayoutNew() {
        return this._layoutNew;
    }

    public void setLayoutNew(boolean layoutNew) {
        this._layoutNew = layoutNew;
    }

    public void makeReadOnly() {
        this._entitiesAdded = Collections.unmodifiableSet(this._entitiesAdded);
        this._entitiesRemoved = Collections.unmodifiableSet(this._entitiesRemoved);
        this._collectionMods = Collections.unmodifiableMap(this._collectionMods);
        this._entitiesPinned = Collections.unmodifiableSet(this._entitiesPinned);
        this._entitiesUnpinned = Collections.unmodifiableSet(this._entitiesUnpinned);
        this._linksAdded = Collections.unmodifiableSet(this._linksAdded);
        this._linksRemoved = Collections.unmodifiableMap(this._linksRemoved);
    }

    public String toString() {
        return "GraphStructureMods{_entitiesAdded=" + this._entitiesAdded + ", _entitiesRemoved=" + this._entitiesRemoved + ", _collectionMods=" + this._collectionMods + ", _entitiesPinned=" + this._entitiesPinned + ", _entitiesUnpinned=" + this._entitiesUnpinned + ", _linksAdded=" + this._linksAdded + ", _linksRemoved=" + this._linksRemoved + ", _layoutNew=" + this._layoutNew + '}';
    }
}

