/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.paterva.maltego.error.reporting.ui.ProblemDto;
import com.paterva.maltego.error.reporting.ui.ProblemDtoBuilder;
import com.paterva.maltego.error.reporting.ui.ProblemReportDialog;
import com.paterva.maltego.error.reporting.ui.ProblemSender;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ProblemReportPanel
extends JPanel {
    private final UIDefaults defaults = UIManager.getLookAndFeelDefaults();
    private ProblemDtoBuilder problemBuilder;
    private final Color bg = this.defaults.getColor("about-box-bg1");
    private final Color floatPanelBg = this.defaults.getColor("about-box-bg2");
    private final Color textBoxesBg = this.defaults.getColor("about-box-bg3");
    private final Color borderColor = this.defaults.getColor("7-white");
    private JButton btnClose;
    private JButton btnSend;
    private JTextField emailTextField;
    private JTextField fldDate;
    private JTextArea fldDescription;
    private JTextArea fldException;
    private JTextField fldJavaVersion;
    private JTextField fldOs;
    private JTextField fldProduct;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    public JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    public JPanel jPanel7;
    public JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;

    public ProblemReportPanel() {
        this.initComponents();
        Color groupTitleColor = this.borderColor;
        ((TitledBorder)this.jPanel7.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this.jPanel2.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this.jPanel8.getBorder()).setTitleColor(groupTitleColor);
        this.emailTextField.setCaretColor(Color.WHITE);
    }

    public void loadProblem(ProblemDtoBuilder problemBuilder) {
        this.problemBuilder = problemBuilder;
        ProblemDto problem = problemBuilder.build();
        this.fldDate.setText(ProblemDtoBuilder.getFormattedDate(problem));
        this.fldException.setText(problem.getStackTrace() != null ? problem.getStackTrace() : problem.getErrorMessage());
        this.fldException.setCaretPosition(0);
        this.fldJavaVersion.setText(problem.getJavaVersion());
        this.fldOs.setText(problem.getOsName());
        this.fldProduct.setText(problem.getMaltegoProduct());
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel6 = new JLabel();
        this.fldDate = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldProduct = new JTextField();
        this.jLabel8 = new JLabel();
        this.emailTextField = new JTextField();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.fldOs = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldJavaVersion = new JTextField();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.fldDescription = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.fldException = new JTextArea();
        this.jPanel3 = new JPanel();
        this.btnSend = new JButton();
        this.btnClose = new JButton();
        this.jPanel8 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setBackground(this.bg);
        this.setMinimumSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        this.jPanel7.setBackground(this.floatPanelBg);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0), (Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), this.borderColor)), NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jPanel7.border.title")));
        this.jPanel7.setLayout(new GridLayout(2, 1));
        this.jPanel4.setBackground(this.floatPanelBg);
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.jPanel4.setLayout(new GridLayout(1, 2));
        this.jPanel5.setBackground(this.floatPanelBg);
        this.jLabel6.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel6.text"));
        this.fldDate.setEditable(false);
        this.fldDate.setBackground(this.textBoxesBg);
        this.fldDate.setForeground(new Color(204, 204, 204));
        this.fldDate.setText(NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.fldDate.text"));
        this.fldDate.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel5.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel5.text"));
        this.jLabel5.setFocusable(false);
        this.fldProduct.setEditable(false);
        this.fldProduct.setBackground(this.textBoxesBg);
        this.fldProduct.setForeground(new Color(204, 204, 204));
        this.fldProduct.setText(NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.fldProduct.text"));
        this.fldProduct.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel8.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel8.text"));
        this.emailTextField.setBackground(this.textBoxesBg);
        this.emailTextField.setForeground(new Color(204, 204, 204));
        this.emailTextField.setText(NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.emailTextField.text"));
        this.emailTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldProduct)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldDate)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel8, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emailTextField))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.fldProduct, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, 16, -2).addComponent(this.fldDate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.emailTextField).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.add(this.jPanel5);
        this.jPanel6.setBackground(this.floatPanelBg);
        this.jLabel3.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel3.text"));
        this.jLabel3.setFocusable(false);
        this.fldOs.setEditable(false);
        this.fldOs.setBackground(this.textBoxesBg);
        this.fldOs.setForeground(new Color(204, 204, 204));
        this.fldOs.setText(NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.fldOs.text"));
        this.fldOs.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel4.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel4.text"));
        this.fldJavaVersion.setEditable(false);
        this.fldJavaVersion.setBackground(this.textBoxesBg);
        this.fldJavaVersion.setForeground(new Color(204, 204, 204));
        this.fldJavaVersion.setText(NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.fldJavaVersion.text"));
        this.fldJavaVersion.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel1.text"));
        this.jLabel1.setFocusable(false);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -2, 90, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldOs).addComponent(this.fldJavaVersion)))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fldOs).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fldJavaVersion).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 17, -2)));
        this.jPanel4.add(this.jPanel6);
        this.jPanel7.add(this.jPanel4);
        this.jPanel1.setBackground(this.floatPanelBg);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.jLabel7.setForeground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jLabel7.text"));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setFocusable(false);
        this.fldDescription.setBackground(this.textBoxesBg);
        this.fldDescription.setColumns(20);
        this.fldDescription.setForeground(new Color(204, 204, 204));
        this.fldDescription.setLineWrap(true);
        this.fldDescription.setRows(3);
        this.fldDescription.setCaretColor(new Color(204, 204, 204));
        this.jScrollPane2.setViewportView(this.fldDescription);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 658, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel7.add(this.jPanel1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel2.setBackground(this.floatPanelBg);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0), (Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), this.borderColor)), NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.fldException.setEditable(false);
        this.fldException.setBackground(this.textBoxesBg);
        this.fldException.setColumns(20);
        this.fldException.setForeground(new Color(204, 204, 204));
        this.fldException.setLineWrap(true);
        this.fldException.setRows(5);
        this.fldException.setTabSize(4);
        this.jScrollPane1.setViewportView(this.fldException);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBackground(this.bg);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSend, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.btnSend.text"));
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProblemReportPanel.this.btnSendActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProblemReportPanel.this.btnCloseActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnSend, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose, -2, 75, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSend).addComponent(this.btnClose)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel8.setBackground(this.floatPanelBg);
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0), (Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), this.borderColor)), NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jPanel8.border.title")));
        this.jPanel8.setLayout(new BorderLayout());
        this.jScrollPane3.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setVerticalScrollBarPolicy(21);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(this.textBoxesBg);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setForeground(new Color(204, 204, 204));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setTabSize(4);
        this.jTextArea1.setText(NbBundle.getMessage(ProblemReportPanel.class, (String)"ProblemReportPanel.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.jTextArea1);
        this.jPanel8.add((Component)this.jScrollPane3, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel8, gridBagConstraints);
    }

    private void btnSendActionPerformed(ActionEvent evt) {
        this.problemBuilder.setDescription(this.fldDescription.getText());
        this.problemBuilder.setEmail(this.emailTextField.getText());
        new ProblemSender(this.problemBuilder).send(true);
        this.getDialog().dispose();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.getDialog().dispose();
    }

    private ProblemReportDialog getDialog() {
        return (ProblemReportDialog)this.getParent().getParent().getParent().getParent();
    }
}

