/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.yfiles;

import com.paterva.maltego.util.yfiles.ImageOutputHandlerJai;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class ImageIoOutputHandlerJai
extends ImageOutputHandlerJai {
    private ImageWriter imageWriter;
    private boolean transparency;

    private ImageIoOutputHandlerJai() {
    }

    public ImageIoOutputHandlerJai(ImageWriter imageWriter) {
        this.setImageWriter(imageWriter);
    }

    public boolean isTransparencyEnabled() {
        return this.transparency;
    }

    public void setTransparencyEnabled(boolean enabled) {
        this.transparency = enabled;
    }

    public void setImageWriter(ImageWriter imageWriter) {
        if (imageWriter == null) {
            throw new NullPointerException();
        }
        if (this.imageWriter != imageWriter) {
            this.imageWriter = imageWriter;
        }
    }

    public ImageWriter getImageWriter() {
        return this.imageWriter;
    }

    @Override
    protected void checkImageWriterIsPresent() throws IOException {
    }

    @Override
    protected BufferedImage createImage(int width, int height) {
        if (this.isTransparencyEnabled()) {
            return new BufferedImage(width, height, 2);
        }
        return new BufferedImage(width, height, 1);
    }

    static ImageWriter checkImageWriterIsPresent(String format) {
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(format);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    static String getExceptionString(String format) {
        return System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " for Java " + System.getProperty("java.version") + " does not support writing " + format + " format.";
    }
}

