/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.memory;

import com.paterva.graph.store.memory.parts.InMemoryPartStore;
import com.paterva.graph.store.memory.parts.PartStore;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.store.AbstractBatchUpdatable;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.SearchOptions;
import com.paterva.maltego.graph.store.data.sort.SortField;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.LinkDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.matching.MatchingRuleFactory;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InMemoryGraphDataStore
extends AbstractBatchUpdatable<Boolean>
implements GraphDataStore,
GraphDataStoreReader,
GraphDataStoreWriter {
    private final GraphID _id;
    private final PartStore _partStore;
    private final EntityRegistry _entityRegistry;
    private final LinkRegistry _linkRegistry;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private GraphDataMods _eventMods;

    public InMemoryGraphDataStore(GraphID id) {
        this._id = id;
        this._partStore = new InMemoryPartStore(this._id);
        this._entityRegistry = EntityRegistry.forGraphID((GraphID)id);
        if (this._entityRegistry == null) {
            throw new IllegalArgumentException("Entity registry not found for graph id: " + id);
        }
        this._linkRegistry = LinkRegistry.forGraphID((GraphID)id);
        if (this._linkRegistry == null) {
            throw new IllegalArgumentException("Link registry not found for graph id: " + id);
        }
    }

    public GraphDataStoreReader getDataStoreReader() {
        return this;
    }

    public GraphDataStoreWriter getDataStoreWriter() {
        return this;
    }

    public int getEntityCount() throws GraphStoreException {
        return this._partStore.getEntities().size();
    }

    public int getLinkCount() throws GraphStoreException {
        return this._partStore.getLinks().size();
    }

    public Set<EntityID> getEntityIDs() throws GraphStoreException {
        return Collections.unmodifiableSet(this._partStore.getEntities().keySet());
    }

    public Set<LinkID> getLinkIDs() throws GraphStoreException {
        return Collections.unmodifiableSet(this._partStore.getLinks().keySet());
    }

    public Map<EntityID, MaltegoEntity> getEntities(EntitiesDataQuery query) {
        Map<EntityID, MaltegoEntity> partialEntities;
        if (query == null) {
            partialEntities = Collections.EMPTY_MAP;
        } else if (query.isAllIDs()) {
            partialEntities = this._partStore.getEntities();
        } else {
            Set ids = query.getIDs();
            partialEntities = new HashMap<EntityID, MaltegoEntity>(ids.size());
            for (EntityID id : ids) {
                MaltegoEntity entity = this.getEntity(id, (EntityDataQuery)query.getPartDataQuery());
                partialEntities.put(id, entity);
            }
        }
        return partialEntities;
    }

    public MaltegoEntity getEntity(EntityID id, EntityDataQuery query) {
        return this._partStore.getEntity(id);
    }

    public MaltegoEntity getEntity(EntityID id) {
        return this.getEntity(id, null);
    }

    public Map<EntityID, String> getEntityTypes(Collection<EntityID> ids) {
        HashMap<EntityID, String> types = new HashMap<EntityID, String>();
        for (EntityID id : ids) {
            types.put(id, this.getEntityType(id));
        }
        return types;
    }

    public Set<String> getEntityTypesOnly(Collection<EntityID> ids) throws GraphStoreException {
        HashSet<String> types = new HashSet<String>();
        for (EntityID id : ids) {
            types.add(this.getEntityType(id));
        }
        return types;
    }

    public String getEntityType(EntityID id) {
        return this._partStore.getEntity(id).getTypeName();
    }

    public Set<String> getEntityTypes() {
        HashSet<String> types = new HashSet<String>();
        for (Map.Entry<EntityID, MaltegoEntity> entry : this._partStore.getEntities().entrySet()) {
            MaltegoEntity entity = entry.getValue();
            types.add(entity.getTypeName());
        }
        return types;
    }

    public Map<LinkID, MaltegoLink> getLinks(LinksDataQuery query) {
        Map<LinkID, MaltegoLink> partialLinks;
        if (query == null) {
            partialLinks = Collections.EMPTY_MAP;
        } else if (query.isAllIDs()) {
            partialLinks = this._partStore.getLinks();
        } else {
            Set ids = query.getIDs();
            partialLinks = new HashMap<LinkID, MaltegoLink>(ids.size());
            for (LinkID id : ids) {
                MaltegoLink link = this.getLink(id, (LinkDataQuery)query.getPartDataQuery());
                partialLinks.put(id, link);
            }
        }
        return partialLinks;
    }

    public MaltegoLink getLink(LinkID id, LinkDataQuery query) {
        return this._partStore.getLink(id);
    }

    public MaltegoLink getLink(LinkID id) {
        return this.getLink(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEntities(Collection<MaltegoEntity> entities) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoEntity entity : entities) {
                this.putEntity(entity);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void putEntity(MaltegoEntity entity) {
        this.beginUpdate();
        try {
            EntityID id = (EntityID)entity.getID();
            if (this._partStore.getEntity(id) != null) {
                this.removeEntity(id);
            }
            this._partStore.putEntity(id, entity);
            this.partAdded(id, entity);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLinks(Collection<MaltegoLink> links) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoLink link : links) {
                this.putLink(link);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void putLink(MaltegoLink link) {
        this.beginUpdate();
        try {
            LinkID id = (LinkID)link.getID();
            if (this._partStore.getLink(id) != null) {
                this.removeLink(id);
            }
            this._partStore.putLink(id, link);
            this.partAdded(id, link);
        }
        finally {
            this.endUpdate();
        }
    }

    private <ID extends Guid, Part extends MaltegoPart> void partAdded(ID id, Part part) {
        part.setGraphID(this._id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntities(Collection<EntityID> entities) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (EntityID entity : entities) {
                this.removeEntity(entity);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void removeEntity(EntityID id) {
        this.beginUpdate();
        try {
            MaltegoEntity maltegoEntity = this._partStore.removeEntity(id);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinks(Collection<LinkID> links) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (LinkID link : links) {
                this.removeLink(link);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void removeLink(LinkID id) {
        this.beginUpdate();
        try {
            MaltegoLink maltegoLink = this._partStore.removeLink(id);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntities(Collection<MaltegoEntity> entities) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoEntity entity : entities) {
                this.replaceEntity(entity);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void updateEntity(MaltegoEntity entity) throws GraphStoreException {
        this.updateEntities(Collections.singleton(entity));
    }

    private void replaceEntity(MaltegoEntity entity) {
        this.beginUpdate();
        try {
            EntityID entityID = (EntityID)entity.getID();
            this.removeEntity(entityID);
            this.putEntity(entity);
            this.getEventMods().getEntitiesUpdated().put(entityID, entity);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLinks(Collection<MaltegoLink> links) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (MaltegoLink link : links) {
                this.replaceLink(link);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void updateLink(MaltegoLink link) throws GraphStoreException {
        this.updateLinks(Collections.singleton(link));
    }

    private void replaceLink(MaltegoLink link) {
        this.beginUpdate();
        try {
            LinkID linkID = (LinkID)link.getID();
            this.removeLink(linkID);
            this.putLink(link);
            this.getEventMods().getLinksUpdated().put(linkID, link);
        }
        finally {
            this.endUpdate();
        }
    }

    public Map<MaltegoEntity, EntityID> getEntityMatches(Collection<MaltegoEntity> entities, MatchingRuleDescriptor ruleDescriptor) throws GraphStoreException {
        MatchingRule rule = MatchingRuleFactory.createFrom((MatchingRuleDescriptor)ruleDescriptor);
        HashMap<MaltegoEntity, EntityID> entityMatches = new HashMap<MaltegoEntity, EntityID>();
        for (MaltegoEntity srcEntity : entities) {
            MaltegoEntity destEntity = this.findEntity(rule, srcEntity);
            if (destEntity == null) continue;
            entityMatches.put(srcEntity, (EntityID)destEntity.getID());
        }
        return entityMatches;
    }

    public Collection<EntityID> getFilteredEntities(String filterText, Collection<EntityID> ids) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EntityID> getSortedEntities(Collection<EntityID> ids, SortField ... sortFields) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<LinkID> getFilteredLinks(String filterText, Collection<LinkID> ids) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<LinkID> getSortedLinks(SortField sortField, Collection<LinkID> ids) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private MaltegoEntity findEntity(MatchingRule rule, MaltegoEntity srcEntity) {
        MaltegoEntity destEntitySameID = this._partStore.getEntity((EntityID)srcEntity.getID());
        if (destEntitySameID != null) {
            return destEntitySameID;
        }
        for (Map.Entry<EntityID, MaltegoEntity> entry : this._partStore.getEntities().entrySet()) {
            MaltegoEntity destEntity = entry.getValue();
            if (!this.isMatch((MaltegoPart)destEntity, (MaltegoPart)srcEntity, rule)) continue;
            return destEntity;
        }
        return null;
    }

    private boolean isMatch(MaltegoPart part1, MaltegoPart part2, MatchingRule rule) {
        int result;
        return rule != null && (result = rule.getMatch((SpecRegistry)this._entityRegistry, (TypedPropertyBag)part1, (TypedPropertyBag)part2)) == 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    protected void fireEvent() {
        if (this._eventMods != null && !this._eventMods.isEmpty()) {
            GraphDataMods eventMods = this._eventMods;
            this._eventMods = null;
            if (!eventMods.isEmpty()) {
                eventMods.makeReadOnly();
                this._changeSupport.firePropertyChange("partsChanged", null, eventMods);
            }
        }
    }

    private GraphDataMods getEventMods() {
        if (this._eventMods == null) {
            this._eventMods = new GraphDataMods();
        }
        return this._eventMods;
    }

    public Set<EntityID> searchEntities(SearchOptions options) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<LinkID> searchLinks(SearchOptions options) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void convertAttachmentIDsToPaths(Map<Integer, String> idToPaths) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void convertAttachmentPathsToIDs(Map<Integer, String> idToPaths) throws GraphStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

