/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.editing.controls.SimpleColorPicker;
import com.paterva.maltego.util.IconSize;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SimpleColorButton
extends JButton {
    public static final String PROP_SELECTED_COLOR = "selectedColor";
    private Color _selectedColor = Color.WHITE;
    private ColorPickerPopup _popup;
    private static final int ICON_WIDTH = 4 + IconSize.TINY.getSize();
    private static final int ICON_HEIGHT = IconSize.TINY.getSize();

    public SimpleColorButton() {
        ColorButtonListener listener = new ColorButtonListener();
        this.addMouseListener(listener);
        this.addAncestorListener(listener);
        this.setIcon(new PrivateIcon());
    }

    public void setSelectedColor(Color color) {
        Color oldColor = this._selectedColor;
        this._selectedColor = color;
        this.firePropertyChange(PROP_SELECTED_COLOR, oldColor, this._selectedColor);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    private class ColorButtonListener
    extends MouseAdapter
    implements AncestorListener {
        private ColorButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.toggleShowPopup();
        }

        public void toggleShowPopup() {
            if (SimpleColorButton.this._popup == null) {
                SimpleColorButton.this._popup = new ColorPickerPopup();
            }
            if (!SimpleColorButton.this._popup.isVisible()) {
                SimpleColorButton.this._popup.show(SimpleColorButton.this, 0, SimpleColorButton.this.getHeight());
            } else {
                SimpleColorButton.this._popup.setVisible(false);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            if (SimpleColorButton.this._popup != null) {
                SimpleColorButton.this._popup.setVisible(false);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class ColorPickerPopup
    extends JPopupMenu
    implements PropertyChangeListener {
        SimpleColorPicker picker;

        public ColorPickerPopup() {
            this.createColorPicker();
            this.setLayout(new BorderLayout());
            this.add((Component)this.picker, "Center");
        }

        private void createColorPicker() {
            this.picker = new SimpleColorPicker();
            this.picker.setSelectedColor(SimpleColorButton.this._selectedColor);
            this.picker.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SimpleColorButton.PROP_SELECTED_COLOR.equals(evt.getPropertyName())) {
                SimpleColorButton.this.setSelectedColor(this.picker.getSelectedColor());
                this.setVisible(false);
            }
        }
    }

    private class PrivateIcon
    implements Icon {
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (SimpleColorButton.this._selectedColor != null) {
                g2d.setColor(SimpleColorButton.this._selectedColor);
                g2d.fillRoundRect(x, y + 1, this.getIconWidth() - 2, this.getIconHeight() - 2, 0, 0);
                g2d.setColor(SimpleColorButton.this._selectedColor.darker());
                g2d.drawRoundRect(x, y + 1, this.getIconWidth() - 2, this.getIconHeight() - 2, 0, 0);
            }
        }

        @Override
        public int getIconWidth() {
            return ICON_WIDTH;
        }

        @Override
        public int getIconHeight() {
            return ICON_HEIGHT;
        }
    }
}

