/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.util.Comparator;
import yguard.A.A.E;
import yguard.A.A.K;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.G.RA;
import yguard.A.G.n;

public class MatrixLayouter
implements n {
    private int _rowSpacing = 10;
    private int _colSpacing = 10;

    public void doLayout(RA graph) {
        int maxPerRow = (int)Math.sqrt(graph.v()) + 1;
        double[] maxColWidth = new double[maxPerRow];
        double maxRowHeight = 0.0;
        X nodes = this.getLayoutNodes(graph);
        int col = 0;
        int row = 0;
        E nc = this.getNodeCursor(graph, nodes);
        while (nc.ok()) {
            Y node = nc.B();
            maxRowHeight = Math.max(graph.X(node), maxRowHeight);
            maxColWidth[col] = Math.max(graph.Q(node), maxColWidth[col]);
            if (col >= maxPerRow - 1) {
                col = 0;
                ++row;
            } else {
                ++col;
            }
            nc.next();
        }
        double[] colCenter = new double[maxPerRow];
        double prevColWidth = 0.0;
        for (int i = 0; i < maxPerRow; ++i) {
            colCenter[i] = prevColWidth + maxColWidth[i] / 2.0;
            prevColWidth += maxColWidth[i] + (double)this._colSpacing;
        }
        col = 0;
        row = 0;
        E nc2 = this.getNodeCursor(graph, nodes);
        while (nc2.ok()) {
            Y node = nc2.B();
            double x2 = colCenter[col];
            double y2 = maxRowHeight / 2.0 + ((double)this._rowSpacing + maxRowHeight) * (double)row;
            graph.D(node, x2, y2);
            if (col >= maxPerRow - 1) {
                col = 0;
                ++row;
            } else {
                ++col;
            }
            nc2.next();
        }
    }

    protected E getNodeCursor(RA graph, X nodes) {
        if (nodes == null) {
            return graph.\u00a4();
        }
        return nodes.\u0121();
    }

    protected X getLayoutNodes(RA graph) {
        final K idProvider = graph.B((Object)"nodeOrder");
        X nodes = new X(graph.\u00a4());
        if (idProvider != null) {
            nodes.sort((Comparator)new Comparator<Y>(){

                @Override
                public int compare(Y o1, Y o2) {
                    return idProvider.getInt((Object)o1) - idProvider.getInt((Object)o2);
                }
            });
        }
        return nodes;
    }

    public int getRowSpacing() {
        return this._rowSpacing;
    }

    public void setRowSpacing(int rowSpacing) {
        this._rowSpacing = rowSpacing;
    }

    public int getColSpacing() {
        return this._colSpacing;
    }

    public void setColSpacing(int colSpacing) {
        this._colSpacing = colSpacing;
    }

    public boolean canLayout(RA lg) {
        return true;
    }
}

