/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeComponent;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeComponents;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import org.openide.util.Exceptions;
import yguard.A.A.Y;
import yguard.A.C.B;
import yguard.A.C.G;
import yguard.A.C.I;
import yguard.A.C.J;
import yguard.A.C.K;
import yguard.A.D.n;
import yguard.A.I.M;
import yguard.A.J.BA;
import yguard.A.J.SA;
import yguard.A.J.U;

public class ZoomAndFlasher
implements ActionListener {
    private static ZoomAndFlasher _instance;
    private static final int FLASH_DURATION = 1000;
    private static final int FLASH_INITIAL_DELAY = 250;
    private static final int FLASH_DELAY = 250;
    private long _startMillis = -1L;
    private final Timer _flashTimer = new Timer(250, this);
    private int _flashingRow = -1;
    private boolean _showCnFlashColour = false;
    private boolean _showEntityFlashColour = false;
    private boolean _isInCollection = false;
    private LightweightEntityRealizer _realizer = null;

    public static synchronized ZoomAndFlasher instance() {
        if (_instance == null) {
            _instance = new ZoomAndFlasher();
        }
        return _instance;
    }

    public ZoomAndFlasher() {
        this._flashTimer.setDelay(250);
        this._flashTimer.setRepeats(true);
    }

    public boolean isShowEntityFlashColour() {
        return this._showEntityFlashColour;
    }

    public LightweightEntityRealizer getRealizer() {
        return this._realizer;
    }

    public void setRealizer(LightweightEntityRealizer realizer) {
        this._realizer = realizer;
    }

    public void zoomAndFlash(GraphID graphID, final EntityID entityID) throws GraphStoreException {
        final GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        EntityID viewEntity = graphStoreView.getModelViewMappings().getViewEntity(entityID);
        if (viewEntity == null) {
            return;
        }
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        final SA graph2D = (SA)wrapper.getGraph();
        final Y node = wrapper.node(viewEntity);
        if (node == null) {
            return;
        }
        final U view = (U)graph2D.\u00f1();
        M center = graph2D.P(node);
        double zoom = entityID.equals((Object)viewEntity) ? 1.0 : 3.0;
        Point2D.Double point2D = new Point2D.Double(center.A, center.D);
        I al = new I(){

            public void animationPerformed(J ae) {
                block9: {
                    view.animationPerformed(ae);
                    if (4 == ae.A()) {
                        BA nr = graph2D.f(node);
                        if (nr != null && nr instanceof LightweightEntityRealizer) {
                            try {
                                LightweightEntityRealizer realizer = (LightweightEntityRealizer)nr;
                                GraphModelViewMappings mappings = graphStoreView.getModelViewMappings();
                                if (mappings.isOnlyModelEntity(entityID)) {
                                    CollectionNodeComponent cnComp;
                                    int viewRow;
                                    CollectionNodeComponent comp = CollectionNodeComponents.getComponent(realizer.getGraphEntity());
                                    if (comp != null && comp instanceof CollectionNodeComponent && (viewRow = (cnComp = comp).scrollToVisible(entityID, 0)) != -1) {
                                        ZoomAndFlasher.this._isInCollection = true;
                                        if (ZoomAndFlasher.this._flashTimer.isRunning() || ZoomAndFlasher.this._realizer != null && !((Object)((Object)ZoomAndFlasher.this._realizer)).equals((Object)realizer)) {
                                            ZoomAndFlasher.this._startMillis = -1L;
                                            ZoomAndFlasher.this.actionPerformed(null);
                                        }
                                        realizer.repaint();
                                        ZoomAndFlasher.this._flashingRow = viewRow;
                                        ZoomAndFlasher.this._realizer = realizer;
                                        ZoomAndFlasher.this._startMillis = System.currentTimeMillis();
                                        ZoomAndFlasher.this._flashTimer.restart();
                                    }
                                    break block9;
                                }
                                ZoomAndFlasher.this._isInCollection = false;
                                if (ZoomAndFlasher.this._flashTimer.isRunning() || ZoomAndFlasher.this._realizer != null && !((Object)((Object)ZoomAndFlasher.this._realizer)).equals((Object)realizer)) {
                                    ZoomAndFlasher.this._startMillis = -1L;
                                    ZoomAndFlasher.this.actionPerformed(null);
                                }
                                realizer.repaint();
                                ZoomAndFlasher.this._realizer = realizer;
                                ZoomAndFlasher.this._startMillis = System.currentTimeMillis();
                                ZoomAndFlasher.this._flashTimer.restart();
                            }
                            catch (GraphStoreException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        } else {
                            ZoomAndFlasher.this._realizer = null;
                        }
                    }
                }
            }
        };
        yguard.A.J.n localViewAnimationFactory = new yguard.A.J.n(view);
        B ao = G.B((B)localViewAnimationFactory.A(zoom, n.B((Point2D)point2D), 500L));
        this.startAnimation(al, ao);
    }

    private void startAnimation(I al, B ao) {
        K player = new K();
        player.A(al);
        player.C(ao);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this._realizer != null && this._realizer.getGraphEntity() != null) {
            if (this._isInCollection) {
                GraphEntity graphEntity = this._realizer.getGraphEntity();
                try {
                    if (!GraphStoreRegistry.getDefault().isExistingAndOpen(graphEntity.getGraphID())) {
                        return;
                    }
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                CollectionNodeComponent comp = CollectionNodeComponents.getComponent(graphEntity);
                if (comp != null && comp instanceof CollectionNodeComponent) {
                    CollectionNodeComponent cnComp = comp;
                    if (this._startMillis + 1000L < System.currentTimeMillis()) {
                        this._showCnFlashColour = false;
                        cnComp.setFlashingRow(-1, this._showCnFlashColour);
                        this._startMillis = -1L;
                        this._flashTimer.stop();
                    } else {
                        this._showCnFlashColour = !this._showCnFlashColour;
                        cnComp.setFlashingRow(this._flashingRow, this._showCnFlashColour);
                    }
                }
            } else if (this._startMillis + 1000L < System.currentTimeMillis()) {
                this._showEntityFlashColour = false;
                this._startMillis = -1L;
                this._flashTimer.stop();
            } else {
                this._showEntityFlashColour = !this._showEntityFlashColour;
            }
            this._realizer.repaint();
        }
    }

    static {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosed".equals(evt.getPropertyName())) {
                    GraphEntity graphEntity;
                    GraphID closedGraphID = (GraphID)evt.getNewValue();
                    ZoomAndFlasher inst = ZoomAndFlasher.instance();
                    LightweightEntityRealizer realizer = inst.getRealizer();
                    if (realizer != null && closedGraphID != null && (graphEntity = realizer.getGraphEntity()) != null && closedGraphID.equals((Object)graphEntity.getGraphID())) {
                        inst.setRealizer(null);
                    }
                }
            }
        });
    }
}

