/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.treelist.lazy.outline.DefaultOutlineCellRenderer;
import com.paterva.maltego.treelist.parts.entity.EntityTable;
import com.paterva.maltego.ui.graph.HoverContext;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;

public class PartHoverEntityTable
extends EntityTable {
    private final String[] _hoverContextIDs;

    public PartHoverEntityTable(String name, boolean small, String ... hoverContextIDs) {
        super(name, small);
        this._hoverContextIDs = hoverContextIDs;
    }

    protected void onPartHovered(GraphID graphID, EntityID id) {
        TableCellRenderer cr;
        DefaultOutlineCellRenderer renderer = null;
        if (this.getParent() instanceof JViewport && (cr = this.getDefaultRenderer(Object.class)) != null && cr instanceof DefaultOutlineCellRenderer) {
            renderer = (DefaultOutlineCellRenderer)cr;
        }
        GraphEntity graphEntity = null;
        if (id != null) {
            graphEntity = new GraphEntity(graphID, id);
            int modelRow = this.getTreelistModel().getModelPartIndex((Guid)id);
            int viewRow = this.convertRowIndexToView(modelRow);
            if (renderer != null) {
                renderer.setHoveredRow(viewRow);
            }
        } else if (renderer != null) {
            renderer.setHoveredRow(-1);
        }
        for (String hoverContextID : this._hoverContextIDs) {
            HoverContext.forContextID(hoverContextID).setHoverModelPart((GraphPart<? extends Guid>)graphEntity);
        }
    }
}

