/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.outline;

import com.paterva.maltego.util.ui.outline.Filterable;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.util.Optional;
import org.openide.nodes.Node;

public class NodeQuickFilter
implements TextQuickFilter {
    private String text;

    public boolean accept(Object obj) {
        if (obj instanceof Node) {
            Node node = (Node)obj;
            Optional<Object> filter = Optional.ofNullable(node.getLookup().lookup(Filterable.class));
            Filterable defaultFilter = NodeQuickFilter.createTextChildrenFilter(node.getDisplayName(), node.getShortDescription());
            return ((Filterable)filter.orElse(defaultFilter)).match(this.text);
        }
        return false;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text.toLowerCase();
    }

    private static Filterable createTextChildrenFilter(String ... fields) {
        return filter -> {
            for (String field : fields) {
                if (!field.toLowerCase().contains(filter)) continue;
                return true;
            }
            return false;
        };
    }
}

