/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;

public class LinkLabel
extends JLabel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private EventListenerList _listeners;
    private Color _highlightColor;
    private Color _oldForeground;

    public LinkLabel() {
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public Color getHighlightColor() {
        return this._highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this._highlightColor = highlightColor;
    }

    public void addActionListener(ActionListener listener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(ActionListener.class, listener);
        }
    }

    protected void fireActionEvent() {
        if (this._listeners != null) {
            ActionEvent evt = new ActionEvent(this, 0, "linkClicked");
            for (ActionListener listener : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                listener.actionPerformed(evt);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.fireActionEvent();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._oldForeground = this.getForeground();
        this.setForeground(this._highlightColor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setForeground(this._oldForeground);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.fireActionEvent();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

