/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class ImageViewControl
extends JPanel {
    private Object _image;
    private JLabel _icon = new JLabel("");

    public ImageViewControl() {
        super(new BorderLayout());
        this.add((Component)this._icon, "North");
    }

    public Object getImage() {
        return this._image;
    }

    public void setImage(Object image) {
        if (image != null && !this.isSupported(image)) {
            throw new IllegalArgumentException("Unsupported image type: " + image.getClass());
        }
        this._image = image;
        if (image == null) {
            this._icon.setText("");
            this._icon.setIcon(null);
        } else if (image instanceof Image) {
            this.setImage((Image)image);
        } else if (image instanceof URL) {
            this.setImageURL((URL)image);
        } else if (image instanceof String) {
            String s = (String)image;
            if (s.startsWith("http:") || s.startsWith("https:")) {
                this.setImageURL(s);
            } else {
                this.setImageResource(s);
            }
        }
    }

    private void setImage(Image image) {
        this._icon.setText("");
        this._icon.setIcon(new ImageIcon(image));
    }

    public boolean isSupported(Object object) {
        return object instanceof Image || object instanceof URL || object instanceof String;
    }

    private void setImageURL(final URL url) {
        this._icon.setText("Downloading... please wait...");
        this._icon.setIcon(null);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedImage image = null;
                IOException exception = null;
                for (int retries = 3; retries > 0; --retries) {
                    try {
                        image = ImageIO.read(url);
                        break;
                    }
                    catch (IOException ex) {
                        exception = ex;
                        continue;
                    }
                }
                ImageViewControl.this.handleDownloadedImage(image, exception);
            }
        }, "Image Downloader");
        t.start();
    }

    private void handleDownloadedImage(final Image image, final IOException ioe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ioe == null) {
                    ImageViewControl.this._icon.setText("");
                    ImageViewControl.this._icon.setIcon(new ImageIcon(image));
                } else {
                    ImageViewControl.this._icon.setText(ioe.getMessage());
                    ImageViewControl.this._icon.setIcon(null);
                }
            }
        });
    }

    private void setImageURL(String url) {
        try {
            this.setImageURL(new URL(url));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setImageResource(String s) {
        this._icon.setText(s);
        this._icon.setIcon(null);
    }
}

