/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.serializer;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.serializer.DisplayDescriptorStub;
import com.paterva.maltego.typing.serializer.EditorTranslator;
import com.paterva.maltego.typing.serializer.EvaluatorFactory;
import com.paterva.maltego.typing.serializer.FieldStub;
import com.paterva.maltego.typing.serializer.UnresolvedReferenceException;
import com.paterva.maltego.typing.serializer.ValidatorStub;
import com.paterva.maltego.typing.serializer.ValidatorTranslator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DisplayDescriptorTranslator {
    private EditorTranslator _editorTranslator;
    private ValidatorTranslator _validatorTranslator;

    public List<FieldStub> translate(DisplayDescriptorEnumeration properties) throws UnresolvedReferenceException {
        LinkedList<FieldStub> stubs = new LinkedList<FieldStub>();
        for (DisplayDescriptor descriptor : properties) {
            FieldStub stub = new FieldStub();
            stubs.add(this.translate(descriptor, stub));
        }
        return stubs;
    }

    public FieldStub translate(DisplayDescriptor from, FieldStub to) throws UnresolvedReferenceException {
        this.update(to, (PropertyDescriptor)from);
        this.update(to, from);
        return to;
    }

    private void update(FieldStub to, PropertyDescriptor from) {
        to.setName(from.getName());
        to.setDisplayName(from.getDisplayName());
        if (!from.getDisplayName().equals(from.getDescription())) {
            to.setDescription(from.getDescription());
        }
        to.setType(DisplayDescriptorTranslator.getType(from.getType()).getTypeName());
        to.setHidden(from.isHidden());
        to.setNullable(from.isNullable());
        to.setReadonly(from.isReadonly());
    }

    private void update(FieldStub to, DisplayDescriptor from) throws UnresolvedReferenceException {
        to.setDisplayName(from.getDisplayName());
        to.setEvaluator(from.getEvaluator() == null ? null : from.getEvaluator().getName().toString());
        to.getDisplayDescriptor().setGroup(from.getGroupName());
        to.getDisplayDescriptor().setFormat(DisplayDescriptorTranslator.getType(from.getType()).getFormatString(from.getFormat()));
        if (from.getDefaultValue() != null && !from.getDefaultValue().equals(from.getTypeDescriptor().getDefaultValue())) {
            to.setDefaultValue(Converter.convertTo(from.getDefaultValue(), from.getType()));
        }
        to.setSampleValue(Converter.convertTo(from.getSampleValue(), from.getType()));
        to.setValidator(this.validatorTranslator().translate(from.getValidator()));
        to.getDisplayDescriptor().setEditor(this.editorTranslator().translate(from.getEditor()));
    }

    private static TypeDescriptor getType(Class type) {
        return TypeRegistry.getDefault().getType(type);
    }

    public DisplayDescriptorCollection translate(List<FieldStub> fields) throws UnresolvedReferenceException {
        DisplayDescriptorList c = new DisplayDescriptorList();
        if (fields != null) {
            for (FieldStub field : fields) {
                c.add(this.translate(field));
            }
        }
        return c;
    }

    public DisplayDescriptor translate(FieldStub field) throws UnresolvedReferenceException {
        String defaultValueStr;
        Object defaultValue;
        Evaluator evaluator;
        String type = field.getType();
        TypeDescriptor td = TypeRegistry.getDefault().getType(type);
        if (td == null) {
            throw new UnresolvedReferenceException("The data type \"" + type + "\" is not known.");
        }
        DisplayDescriptor descriptor = new DisplayDescriptor(td.getType(), field.getName(), field.getDisplayName());
        if (field.getDefaultValue() == null) {
            descriptor.setDefaultValue(td.getDefaultValue());
        } else {
            descriptor.setDefaultValue(td.convert(field.getDefaultValue()));
        }
        descriptor.setSampleValue(td.convert(field.getSampleValue()));
        descriptor.setHidden(field.isHidden());
        descriptor.setNullable(field.isNullable());
        descriptor.setReadonly(field.isReadonly());
        descriptor.setDescription(field.getDescription());
        if (field.getRangeValidator() != null) {
            descriptor.setValidator(this.validatorTranslator().translate(td, (ValidatorStub)field.getRangeValidator()));
        }
        if ((evaluator = EvaluatorFactory.create(field.getEvaluator())) == null && (defaultValue = descriptor.getDefaultValue()) instanceof String && StringUtils.isNotBlank((CharSequence)(defaultValueStr = (String)defaultValue))) {
            descriptor.setEvaluator(EvaluatorFactory.createForDefaultValue(defaultValueStr));
        }
        descriptor.setEvaluator(evaluator);
        if (field.getDisplayDescriptor() != null) {
            DisplayDescriptorStub dds = field.getDisplayDescriptor();
            descriptor.setFormat(td.getFormat(dds.getFormat()));
            descriptor.setSortOrder(dds.getSortIndex());
            descriptor.setGroupName(dds.getGroup());
            if (dds.getEditor() != null) {
                descriptor.setEditor(this.editorTranslator().translate(td, dds.getEditor(), descriptor));
            }
        }
        return descriptor;
    }

    private EditorTranslator editorTranslator() {
        if (this._editorTranslator == null) {
            this._editorTranslator = new EditorTranslator();
        }
        return this._editorTranslator;
    }

    private ValidatorTranslator validatorTranslator() {
        if (this._validatorTranslator == null) {
            this._validatorTranslator = new ValidatorTranslator();
        }
        return this._validatorTranslator;
    }
}

