/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.view.MachineActions;
import com.paterva.maltego.automation.view.startup.EntityNodePayload;
import com.paterva.maltego.automation.view.startup.Helper;
import com.paterva.maltego.automation.view.startup.MachineMenuFactory;
import com.paterva.maltego.automation.view.startup.MachinesForNodes;
import com.paterva.maltego.automation.view.startup.RunActions;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.util.ui.menu.BasicMenuViewItem;
import com.paterva.maltego.util.ui.menu.MenuViewItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.Exceptions;

public class DefaultMachineMenuFactory
extends MachineMenuFactory {
    @Override
    public MenuViewItem[] getMenuItems(GraphID graphID, Collection<EntityID> entities) {
        ArrayList<BasicMenuViewItem> items = new ArrayList<BasicMenuViewItem>();
        try {
            List<MachineDescriptor> machines = MachinesForNodes.get(graphID, entities);
            if (!machines.isEmpty()) {
                for (MachineDescriptor machine : machines) {
                    RunMachineAction action = new RunMachineAction(machine, graphID, entities);
                    BasicMenuViewItem item = new BasicMenuViewItem((Action)action);
                    item.setName(machine.getName());
                    item.setDisplayName(machine.getDisplayName());
                    item.setDescription(machine.getDescription());
                    item.setSettingsAction((ActionListener)new MachineSettingsAction(machine.getName()));
                    items.add(item);
                }
                Collections.sort(items, new MachineMenuFactory.DisplayAscendingComparator());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items.toArray(new MenuViewItem[items.size()]);
    }

    private static class MachineSettingsAction
    implements ActionListener {
        private final String _machineName;

        public MachineSettingsAction(String machineName) {
            this._machineName = machineName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MachineActions.editMachine(this._machineName);
        }
    }

    private class RunMachineAction
    extends AbstractAction {
        private final MachineDescriptor _machine;
        private final GraphID _graphID;
        private final Collection<EntityID> _entities;

        public RunMachineAction(MachineDescriptor machine, GraphID graphID, Collection<EntityID> entities) {
            super(machine.getDisplayName());
            this._machine = machine;
            this._graphID = graphID;
            this._entities = entities;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunActions.runMachine(Helper.getTarget(), this._machine, new EntityNodePayload(this._graphID, this._entities));
        }
    }
}

