/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api.inheritance;

import com.paterva.maltego.entity.api.inheritance.InheritanceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import yguard.A.A.A;
import yguard.A.A.D;
import yguard.A.A.J;
import yguard.A.A.K;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.F.B;
import yguard.A.F.H;
import yguard.A.F.I;

public class MultiInheritanceAdapter<T> {
    private static final boolean DEBUG = false;
    private final InheritanceProvider<T> _provider;
    private T _item;
    private Map<T, List<T>> _inheritanceMap;
    private D _graph;
    private Map<T, Y> _itemToNodeMap;
    private Map<Y, T> _nodeToItemMap;

    public MultiInheritanceAdapter(InheritanceProvider<T> provider) {
        this._provider = provider;
    }

    public List<T> getTopologicalInheritanceList(T item) {
        T baseItem;
        List<T> baseItems = this._provider.getBaseItems(item);
        if (baseItems.isEmpty()) {
            return Arrays.asList(item);
        }
        if (baseItems.size() == 1 && (baseItem = baseItems.get(0)) != null && baseItem.equals(this._provider.getRootItem())) {
            return Arrays.asList(item, baseItem);
        }
        this._item = item;
        this.createInheritanceMap();
        this.createInheritanceGraph();
        this.removeCycles();
        return this.createTopologicalList();
    }

    private void createInheritanceMap() {
        this._inheritanceMap = new HashMap<T, List<T>>();
        T rootItem = this._provider.getRootItem();
        if (rootItem != null) {
            this._inheritanceMap.put(rootItem, this._provider.getBaseItems(rootItem));
        }
        this.createInheritanceMapRecursive(this._item);
    }

    private void createInheritanceMapRecursive(T item) {
        List<T> baseItems;
        if (!this._inheritanceMap.containsKey(item) && (baseItems = this._provider.getBaseItems(item)) != null) {
            List<T> validBaseItems = this.getValidBaseItems(baseItems);
            this._inheritanceMap.put(item, validBaseItems);
            for (T baseItem : validBaseItems) {
                this.createInheritanceMapRecursive(baseItem);
            }
        }
    }

    private List<T> getValidBaseItems(List<T> baseItems) {
        ArrayList<T> validBaseItems = new ArrayList<T>();
        for (T baseItem : baseItems) {
            if (this._provider.getBaseItems(baseItem) == null) continue;
            validBaseItems.add(baseItem);
        }
        if (validBaseItems.isEmpty() && this._provider.getRootItem() != null) {
            validBaseItems.add(this._provider.getRootItem());
        }
        return validBaseItems;
    }

    private void createInheritanceGraph() {
        this._graph = new D();
        this._itemToNodeMap = new HashMap<T, Y>();
        this._nodeToItemMap = new HashMap<Y, T>();
        for (T item : this._inheritanceMap.keySet()) {
            Y node = this._graph.w();
            this._itemToNodeMap.put(item, node);
            this._nodeToItemMap.put(node, item);
        }
        for (T item : this._inheritanceMap.keySet()) {
            List<T> baseItems = this._inheritanceMap.get(item);
            for (T baseItem : baseItems) {
                this._graph.A(this._itemToNodeMap.get(item), this._itemToNodeMap.get(baseItem));
            }
        }
    }

    private void removeCycles() {
        boolean edgeRemoved;
        Y startNode = this._itemToNodeMap.get(this._item);
        Y rootNode = this._itemToNodeMap.get(this._provider.getRootItem());
        FurthestEdge furthestEdge = new FurthestEdge(this._graph, startNode);
        do {
            edgeRemoved = false;
            J edges = this._graph.\u00cf();
            I.A((D)this._graph, (J)edges, (K)furthestEdge);
            Double minimumCost = null;
            yguard.A.A.H edgeToRemove = null;
            for (yguard.A.A.H edge : this._graph.\u00aa()) {
                if (!edges.getBool((Object)edge)) continue;
                double cost = furthestEdge.getDouble(edge);
                if (minimumCost != null && !(cost < minimumCost)) continue;
                minimumCost = cost;
                edgeToRemove = edge;
            }
            this._graph.A(edges);
            if (edgeToRemove == null) continue;
            T sourceItem = this._nodeToItemMap.get(edgeToRemove.X());
            T targetItem = this._nodeToItemMap.get(edgeToRemove.V());
            System.out.println("WARNING: Cyclic inheritance detected for " + this._item + "! " + sourceItem + " -> " + targetItem + " ignored.");
            List<T> baseItems = this._inheritanceMap.get(sourceItem);
            baseItems.remove(targetItem);
            if (baseItems.isEmpty() && this._provider.getRootItem() != null) {
                baseItems.add(this._provider.getRootItem());
                this._graph.B(edgeToRemove, edgeToRemove.X(), rootNode);
            } else {
                this._graph.H(edgeToRemove);
            }
            edgeRemoved = true;
        } while (edgeRemoved);
    }

    private List<T> createTopologicalList() {
        X topological = B.A((D)this._graph);
        ArrayList<T> topologicalEntities = new ArrayList<T>();
        for (Y node : topological.\u0123()) {
            topologicalEntities.add(this._nodeToItemMap.get(node));
        }
        return topologicalEntities;
    }

    private static class FurthestEdge
    extends yguard.A.D.D {
        private final D _graph;
        private final Y _startNode;

        public FurthestEdge(D graph, Y startNode) {
            this._graph = graph;
            this._startNode = startNode;
        }

        public double getDouble(Object o) {
            yguard.A.A.H edge = (yguard.A.A.H)o;
            Y stopNode = edge.X();
            if (this._startNode.equals(stopNode)) {
                return 1.0;
            }
            A path = H.A((D)this._graph, (Y)this._startNode, (Y)stopNode, (boolean)true);
            return 1.0 / (double)path.size();
        }
    }
}

