/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SerializedTaskQueue {
    private static final Logger LOG = Logger.getLogger(SerializedTaskQueue.class.getName());
    private final LinkedList<Runnable> multithreadedTaskQueue = new LinkedList();
    private final ReentrantLock processLock = new ReentrantLock(false);
    private final MultithreadedTaskProcessor multithreadedTaskProcessor = new MultithreadedTaskProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void performNonThreaded(Runnable task, Executor workerpool) {
        if (this.processLock.tryLock()) {
            try {
                LinkedList<Runnable> linkedList = this.multithreadedTaskQueue;
                // MONITORENTER : linkedList
                if (!this.multithreadedTaskQueue.isEmpty()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("multithreaded tasks are in queue . register non threaded task " + task.toString() + " to multithreaded queue (non threaded task will be performed multithreaded)");
                    }
                    this.performMultiThreaded(task, workerpool);
                    // MONITOREXIT : linkedList
                    return;
                }
                // MONITOREXIT : linkedList
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("performing " + task);
                }
                task.run();
                return;
            }
            finally {
                this.processLock.unlock();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("a task is already running. register non threaded task " + task.toString() + " to perform it multithreaded");
        }
        this.performMultiThreaded(task, workerpool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMultiThreaded(Runnable task, Executor workerpool) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("adding multithreaded " + task.toString() + " to queue which will be processed multithreaded");
        }
        LinkedList<Runnable> linkedList = this.multithreadedTaskQueue;
        synchronized (linkedList) {
            if (this.multithreadedTaskQueue.isEmpty()) {
                this.multithreadedTaskQueue.addLast(task);
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("starting worker");
                    }
                    workerpool.execute(this.multithreadedTaskProcessor);
                }
                catch (RejectedExecutionException ree) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("task has been rejected by worker pool " + workerpool + " (worker pool cosed?) performing task by starting a new thread");
                    }
                    Thread t = new Thread((Runnable)this.multithreadedTaskProcessor, "SerializedTaskQueueFallbackThread");
                    t.setDaemon(true);
                    t.start();
                }
            } else {
                this.multithreadedTaskQueue.addLast(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void performPendingTasks() {
        this.processLock.lock();
        try {
            while (true) {
                LinkedList<Runnable> linkedList;
                Runnable task;
                block16: {
                    task = null;
                    linkedList = this.multithreadedTaskQueue;
                    // MONITORENTER : linkedList
                    if (!this.multithreadedTaskQueue.isEmpty()) {
                        task = this.multithreadedTaskQueue.get(0);
                    }
                    // MONITOREXIT : linkedList
                    if (task != null) {
                        try {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("performing " + task);
                            }
                            task.run();
                        }
                        catch (Throwable t) {
                            if (!LOG.isLoggable(Level.FINE)) break block16;
                            LOG.fine("error occured by processing " + task + " " + t.toString());
                        }
                    }
                }
                linkedList = this.multithreadedTaskQueue;
                // MONITORENTER : linkedList
                this.multithreadedTaskQueue.remove(task);
                if (this.multithreadedTaskQueue.isEmpty()) {
                    // MONITOREXIT : linkedList
                    return;
                }
                // MONITOREXIT : linkedList
            }
        }
        finally {
            this.processLock.unlock();
        }
    }

    private final class MultithreadedTaskProcessor
    implements Runnable {
        private MultithreadedTaskProcessor() {
        }

        public void run() {
            SerializedTaskQueue.this.performPendingTasks();
        }
    }
}

