/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.graph.state.SignalMessage;
import com.paterva.maltego.collab.session.PayloadHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class RequestGraphMessage
extends SignalMessage {
    public static final String ACTION = "getgraph";
    private String _transactionID;
    private String _graph;
    private String _entitySpecs;
    private String _linkSpecs;
    private String _icons;
    private String _layoutSettings;
    private String _collectionSettings;

    private RequestGraphMessage(SignalMessage.Type type) {
        super(type, ACTION);
    }

    private RequestGraphMessage(String transactionID, String graph, String entitySpecs, String linkSpecs, String icons, String layoutSettings, String collectionSettings) {
        super(SignalMessage.Type.Response, ACTION);
        this._transactionID = transactionID;
        this._graph = graph;
        this._entitySpecs = entitySpecs;
        this._linkSpecs = linkSpecs;
        this._icons = icons;
        this._layoutSettings = layoutSettings;
        this._collectionSettings = collectionSettings;
    }

    public String getLastTransactionID() {
        return this._transactionID;
    }

    public String getGraph() {
        return this._graph;
    }

    public String getEntitySpecs() {
        return this._entitySpecs;
    }

    public String getLinkSpecs() {
        return this._linkSpecs;
    }

    public String getIcons() {
        return this._icons;
    }

    public String getLayoutSettings() {
        return this._layoutSettings;
    }

    public String getCollectionSettings() {
        return this._collectionSettings;
    }

    @Override
    protected String getBody() throws CollaborationException {
        if (this._transactionID != null) {
            Map<String, String> transactionIDs = Collections.singletonMap("id", this._transactionID);
            String payload = PayloadHelper.createPayload("graph", transactionIDs, this.getGraph(), false);
            return payload + "\n" + this.getIcons() + "\n" + this.getEntitySpecs() + "\n" + this.getLinkSpecs() + "\n" + this.getLayoutSettings() + "\n" + this.getCollectionSettings();
        }
        return super.getBody();
    }

    public static RequestGraphMessage request() {
        return new RequestGraphMessage(SignalMessage.Type.Request);
    }

    public static RequestGraphMessage response(String transactionID, String graph, String entitySpecs, String linkSpecs, String icons, String layoutSettings, String collectionSettings) {
        return new RequestGraphMessage(transactionID, graph, entitySpecs, linkSpecs, icons, layoutSettings, collectionSettings);
    }

    public static SignalMessage parse(SignalMessage.Type type, String action, String body) throws CollaborationException {
        if (ACTION.equals(action)) {
            if (type == SignalMessage.Type.Request) {
                return new RequestGraphMessage(type);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            Map<String, String> payloads = PayloadHelper.getBodies("<temp>" + body + "</temp>");
            String graph = PayloadHelper.getBody("graph", payloads.get("graph"), map, false);
            String especs = payloads.get("especs");
            String lspecs = payloads.get("lspecs");
            String icons = payloads.get("icons");
            String layoutSettings = payloads.get("layouts");
            String collectionSettings = payloads.get("collect");
            String xaction = (String)map.get("id");
            return new RequestGraphMessage(xaction, graph, especs, lspecs, icons, layoutSettings, collectionSettings);
        }
        return null;
    }
}

