/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CachedMachineInputProvider
extends MachineInputProvider {
    private Map<MachineDescriptor, ConstraintCache> _map = new HashMap<MachineDescriptor, ConstraintCache>();
    private RegistryListener _listener = new EntityRegistryListener();

    public CachedMachineInputProvider() {
        EntityRegistry.getDefault().addRegistryListener(this._listener);
    }

    @Override
    public MachineInput getInputDescriptor(MachineDescriptor machine) {
        ConstraintCache cache = this._map.get(machine);
        if (cache == null) {
            cache = new ConstraintCache(new Date(), this.calculateConstraint(machine));
            this._map.put(machine, cache);
        } else {
            this.update(machine, cache);
        }
        return cache.getConstraint();
    }

    private boolean shouldUpdate(Date cacheDate, Date machineDate) {
        if (machineDate == null) {
            return false;
        }
        return cacheDate.compareTo(machineDate) < 0;
    }

    private void update(MachineDescriptor machine, ConstraintCache cache) {
        if (this.shouldUpdate(cache.getLastModified(), machine.getLastModified())) {
            cache.setLastModified(new Date());
            cache.setConstraint(this.calculateConstraint(machine));
        }
    }

    private class EntityRegistryListener<T extends TypeSpec>
    implements RegistryListener<T> {
        private EntityRegistryListener() {
        }

        public void typeAdded(RegistryEvent event) {
            CachedMachineInputProvider.this._map.clear();
        }

        public void typeRemoved(RegistryEvent event) {
            CachedMachineInputProvider.this._map.clear();
        }

        public void typeUpdated(RegistryEvent event) {
        }
    }

    private static class ConstraintCache {
        private Date _lastModified;
        private MachineInput _constraint;

        public ConstraintCache(Date lastModified, MachineInput constraint) {
            this._lastModified = lastModified;
            this._constraint = constraint;
        }

        public Date getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(Date lastModified) {
            this._lastModified = lastModified;
        }

        public MachineInput getConstraint() {
            return this._constraint;
        }

        public void setConstraint(MachineInput constraint) {
            this._constraint = constraint;
        }
    }
}

