/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.transforms;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.manager.imex.transforms.TransformSettingsWrapper;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformSettingsEntry
extends Entry<TransformSettings> {
    public static final String DefaultFolder = "TransformRepositories";
    public static final String Type = "transformsettings";

    public TransformSettingsEntry(TransformDefinition transform) {
        super((Object)transform, "TransformRepositories/" + transform.getRepositoryName(), transform.getName() + "." + Type, transform.getName());
    }

    public TransformSettingsEntry(String path) {
        super(path);
    }

    protected TransformSettings read(InputStream is) throws IOException {
        try {
            TransformSettings transformSettings = new TransformSettingsSerializer().read(is);
            TransformSettingsWrapper wrapper = new TransformSettingsWrapper(transformSettings, this.getTypeName());
            return wrapper;
        }
        catch (XmlSerializationException ex) {
            throw new IOException(ex);
        }
    }

    protected void write(TransformSettings data, OutputStream os) throws IOException {
        if (data instanceof TransformDefinition) {
            TransformDefinition transformDefinition = (TransformDefinition)data;
            new TransformSettingsSerializer().write(transformDefinition, os, true);
        }
    }
}

