/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details.files;

import com.paterva.maltego.graph.table.ui.wizard.ImportFileController;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.ValidatingPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TabularFilePanel
extends ValidatingPanel {
    private JButton browseButton;
    private JPanel dummyPanel;
    private JLabel fileLabel;
    private JTextField filesTextField;

    public TabularFilePanel(ValidatingController controller) {
        super(controller);
        this.initComponents();
    }

    public void addNotify() {
        super.addNotify();
        this.filesTextField.getDocument().addDocumentListener((DocumentListener)this.getChangeEventPropagator());
    }

    public void removeNotify() {
        this.filesTextField.getDocument().removeDocumentListener((DocumentListener)this.getChangeEventPropagator());
        super.removeNotify();
    }

    public void setFiles(List<String> files) {
        String filesString = String.join((CharSequence)", ", files);
        this.filesTextField.setText(filesString);
    }

    public List<String> getFiles() {
        String text = this.filesTextField.getText();
        List<String> files = Arrays.asList(text.split(",")).stream().map(String::trim).collect(Collectors.toList());
        return files;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(400, size.height);
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.filesTextField = new JTextField();
        this.browseButton = new JButton();
        this.dummyPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 12));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(TabularFilePanel.class, (String)"TabularFilePanel.fileLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.fileLabel, gridBagConstraints);
        this.filesTextField.setText(NbBundle.getMessage(TabularFilePanel.class, (String)"TabularFilePanel.filesTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.filesTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(TabularFilePanel.class, (String)"TabularFilePanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabularFilePanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.browseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add(this.dummyPanel, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        ImportFileController controller = new ImportFileController();
        EditDialogDescriptor descriptor = new EditDialogDescriptor((WizardDescriptor.Panel)controller);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (NotifyDescriptor.OK_OPTION.equals(result)) {
            try {
                List files = (List)descriptor.getProperty("files");
                if (!files.isEmpty()) {
                    List<String> filesList = files.stream().map(File::getPath).collect(Collectors.toList());
                    this.setFiles(filesList);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

