/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.util.NormalException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class TransformRunnerV2 {
    private static final Logger LOG = Logger.getLogger(TransformRunnerV2.class.getName());
    private final GraphID _graphID;
    private final EntityFactory _factory;
    private final EntityRegistry _registry;
    private long _lastLicenseCheck = 0L;
    private static final int MinutesBetweenChecks = 5;
    private static final int MillisBetweenChecks = 300000;

    public TransformRunnerV2(GraphID graphID, EntityFactory factory, EntityRegistry registry) {
        this._graphID = graphID;
        this._factory = factory;
        this._registry = registry;
    }

    protected abstract RunResultV2 doRunTransform(MaltegoEntity var1) throws Exception;

    protected abstract RequestProcessor processor();

    public GraphID getGraphID() {
        return this._graphID;
    }

    public EntityFactory getFactory() {
        return this._factory;
    }

    public EntityRegistry getRegistry() {
        return this._registry;
    }

    public Cancellable run(MaltegoEntity input, CallbackV2 cb) {
        Runnable runnable = () -> {
            try {
                RunResultV2 result = this.doTransform(input);
                cb.success(result);
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg != null && (msg.contains("timed out") || msg.contains("No response received"))) {
                    LOG.warning(msg);
                } else {
                    NormalException.logStackTrace((Throwable)ex);
                }
                cb.exception(ex, input);
            }
        };
        return this.processor().post(runnable);
    }

    private RunResultV2 doTransform(MaltegoEntity input) throws TransformRunException {
        if (!this.validateLicense()) {
            throw new TransformRunException("Maltego needs to be activated before it can run transforms (alternatively please check your network and proxy settings).");
        }
        try {
            return this.doRunTransform(input);
        }
        catch (Exception ex) {
            if (ex instanceof TransformRunException) {
                throw (TransformRunException)((Object)ex);
            }
            throw new TransformRunException(ex);
        }
    }

    private boolean validateLicense() {
        long time = System.currentTimeMillis();
        long delta = time - this._lastLicenseCheck;
        if (delta > 300000L) {
            this._lastLicenseCheck = time;
            return LicenseManager.A().A(false, false);
        }
        return true;
    }

    protected static class RunResultV2 {
        private final MaltegoEntity _input;
        private final List<MaltegoEntity> _entities = new ArrayList<MaltegoEntity>();
        private List<TransformMessage> _notifications;

        public RunResultV2(MaltegoEntity input) {
            this._input = input;
        }

        public MaltegoEntity getInput() {
            return this._input;
        }

        public List<MaltegoEntity> getEntities() {
            return this._entities;
        }

        public List<TransformMessage> getMessages() {
            if (this._notifications == null) {
                this._notifications = new LinkedList<TransformMessage>();
            }
            return this._notifications;
        }
    }

    public static interface CallbackV2 {
        public void exception(Exception var1, MaltegoEntity var2);

        public void success(RunResultV2 var1);
    }
}

