/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeader;
import com.paterva.maltego.graph.table.ui.wizard.SampleTableModel;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.IconSize;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class EntitySampleTableModel
extends SampleTableModel {
    @Override
    protected Object getHeaderValue(int column) {
        Object headerValue;
        TabularGraphEntity entity = TabularGraphUtils.getEntity((TabularGraph)this.getTabularGraph(), (int)column);
        String columnName = this.getTabularGraph().getColumnNames()[column];
        if (entity != null) {
            int num = this.getTabularGraph().getEntities().indexOf(entity) + 1;
            PropertyDescriptor pd = entity.getProperty(column);
            ImageIcon icon = EntityImageFactory.getDefault().getTypeIcon(entity.getEntitySpecName(), IconSize.MEDIUM.getSize(), IconSize.MEDIUM.getSize());
            String headerText = this.createHTMLHeader(columnName, pd != null ? pd.getDisplayName() : "");
            headerValue = new SampleHeader(icon, headerText, num);
        } else {
            headerValue = this.createHTMLHeader(columnName, "Unmapped");
        }
        return headerValue;
    }

    @Override
    protected void onColumnSelected(int column) {
        JTable table;
        TabularGraphEntity entity = TabularGraphUtils.getEntity((TabularGraph)this.getTabularGraph(), (int)column);
        if (entity != null && (table = this.getTable()) instanceof SampleTableModel.CustomizedSelectionTable) {
            SampleTableModel.CustomizedSelectionTable cst = (SampleTableModel.CustomizedSelectionTable)((Object)table);
            cst.select(entity.getColumns());
        }
    }

    @Override
    protected void onColumnToggled(int[] previousSelectedColumns, int column, boolean isSelected) {
        List entities = TabularGraphUtils.getEntities((TabularGraph)this.getTabularGraph(), (int[])previousSelectedColumns);
        if (entities.size() == 1) {
            if (isSelected) {
                TabularGraphEntity entity = TabularGraphUtils.getEntity((TabularGraph)this.getTabularGraph(), (int)column);
                if (entity == null) {
                    PropertyDescriptor pd = TabularGraphUtils.getNextUnusedProperty((TabularGraphEntity)((TabularGraphEntity)entities.get(0)));
                    ((TabularGraphEntity)entities.get(0)).put(column, pd);
                }
            } else {
                this.getTabularGraph().removeColumnsFromEntities(new int[]{column});
            }
            this.updateTableHeaders();
        }
    }

    @Override
    protected void onTabularGraphChanged(PropertyChangeEvent evt) {
        super.onTabularGraphChanged(evt);
        if (this.isUpdatingTabularGraph()) {
            return;
        }
        if ("entityAdded".equals(evt.getPropertyName()) || "entityRemoved".equals(evt.getPropertyName()) || "entityUpdated".equals(evt.getPropertyName()) || "columnNamesChanged".equals(evt.getPropertyName())) {
            this.updateTableHeaders();
        }
    }
}

