/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.netbeans.modules.autoupdate.services.MessageChecksumValidator;
import org.netbeans.modules.autoupdate.services.MessageDigestValidator;
import org.netbeans.modules.autoupdate.services.MessageMultiValidator;
import org.netbeans.modules.autoupdate.services.MessageValidator;
import org.netbeans.modules.autoupdate.services.Utilities;

public class ExternalFile {
    private static final Logger LOG = Logger.getLogger(ExternalFile.class.getName());
    private String name;
    private final List<String> urls = new ArrayList<String>();
    private Long crc32 = null;
    private Integer size = null;
    private final Map<String, byte[]> messageDigest = new HashMap<String, byte[]>();

    public static ExternalFile fromStream(String name, InputStream is) throws IOException {
        ExternalFile ext = new ExternalFile();
        ext.setName(name);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        String line = br.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                if (line.startsWith("SIZE:")) {
                    ext.setSize(Integer.parseInt(line.substring(5).trim()));
                } else if (line.startsWith("CRC:")) {
                    ext.setCrc32(Long.parseLong(line.substring(4).trim()));
                } else if (line.startsWith("URL:")) {
                    int index;
                    String url = line.substring(4).trim();
                    while ((index = url.indexOf("${")) != -1) {
                        int end = url.indexOf("}", index);
                        String propName = url.substring(index + 2, end);
                        String propVal = System.getProperty(propName);
                        if (propVal == null) {
                            throw new IOException("Can't find property " + propName);
                        }
                        url = url.substring(0, index) + propVal + url.substring(end + 1);
                    }
                    ext.getModifiableUrls().add(url);
                } else if (line.startsWith("MessageDigest:")) {
                    String[] parts = line.substring(14).trim().split("\\s+");
                    if (parts.length == 2) {
                        try {
                            ext.getModifiableMessageDigests().put(parts[0], Utilities.hexDecode(parts[1]));
                        }
                        catch (IllegalArgumentException ex) {
                            LOG.log(Level.INFO, MessageFormat.format("Invalidly formatted MessageDigest line found in {1}: {0}", line, name), ex);
                        }
                    } else {
                        LOG.log(Level.INFO, "Invalidly formatted MessageDigest line found in {1}: {0}", new Object[]{line, name});
                    }
                } else if (!line.trim().isEmpty()) {
                    LOG.log(Level.INFO, "Invalid content found in {1}: {0}", new Object[]{line, name});
                }
            }
            line = br.readLine();
        }
        return ext;
    }

    private ExternalFile() {
    }

    public List<String> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    public Map<String, byte[]> getMessageDigests() {
        return Collections.unmodifiableMap(this.messageDigest);
    }

    private List<String> getModifiableUrls() {
        return this.urls;
    }

    private Map<String, byte[]> getModifiableMessageDigests() {
        return this.messageDigest;
    }

    public Long getCrc32() {
        return this.crc32;
    }

    private void setCrc32(Long crc32) {
        this.crc32 = crc32;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageMultiValidator getValidator() {
        ArrayList<MessageValidator> validators = new ArrayList<MessageValidator>(2);
        validators.add(new MessageChecksumValidator(new CRC32(), this.getCrc32()));
        for (Map.Entry<String, byte[]> entry : this.getMessageDigests().entrySet()) {
            try {
                validators.add(new MessageDigestValidator(MessageDigest.getInstance(entry.getKey()), entry.getValue()));
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.log(Level.INFO, "Requested message digest {0} not found for {1}", new Object[]{entry.getKey(), this.getName()});
            }
        }
        return new MessageMultiValidator(validators);
    }
}

