/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotThread;

final class PolyglotContextThreadLocal
extends ThreadLocal<Object> {
    private final Assumption singleThread = Truffle.getRuntime().createAssumption("single thread");
    private volatile PolyglotContextImpl activeSingleContext;
    private PolyglotContextImpl activeSingleContextNonVolatile;
    @CompilerDirectives.CompilationFinal
    private volatile Thread activeSingleThread;

    PolyglotContextThreadLocal() {
    }

    @Override
    protected Object initialValue() {
        if (Thread.currentThread() == this.activeSingleThread) {
            PolyglotContextImpl context = this.activeSingleContext;
            this.activeSingleContext = null;
            this.activeSingleThread = null;
            this.activeSingleContextNonVolatile = null;
            return context;
        }
        return null;
    }

    public boolean isSet() {
        if (this.singleThread.isValid()) {
            boolean set = this.activeSingleContext != null;
            return Thread.currentThread() == this.activeSingleThread && set;
        }
        return this.getTL() != null;
    }

    public Object getEntered() {
        if (this.singleThread.isValid()) {
            assert (Thread.currentThread() == this.activeSingleThread) : PolyglotContextThreadLocal.failIllegalState();
            return this.activeSingleContextNonVolatile;
        }
        return this.getTL();
    }

    private static String failIllegalState() {
        throw new IllegalStateException("No context entered.");
    }

    @Override
    public Object get() {
        Object context;
        if (this.singleThread.isValid()) {
            if (Thread.currentThread() == this.activeSingleThread) {
                context = this.activeSingleContext;
            } else {
                CompilerDirectives.transferToInterpreter();
                context = this.getImplSlowPath();
            }
        } else {
            context = this.getTL();
        }
        return context;
    }

    @Override
    public void set(Object value) {
        this.setReturnParent((PolyglotContextImpl)value);
    }

    PolyglotContextImpl setReturnParent(PolyglotContextImpl value) {
        if (this.singleThread.isValid()) {
            PolyglotContextImpl prev;
            if (Thread.currentThread() == this.activeSingleThread) {
                prev = this.activeSingleContext;
                this.activeSingleContext = value;
                this.activeSingleContextNonVolatile = value;
            } else {
                CompilerDirectives.transferToInterpreter();
                prev = this.setReturnParentSlowPath(value);
            }
            return prev;
        }
        return this.setTLReturnParent(value);
    }

    private synchronized Object getImplSlowPath() {
        if (!this.singleThread.isValid()) {
            return this.getTL();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private Object getTL() {
        Thread current = Thread.currentThread();
        if (current instanceof PolyglotThread) {
            PolyglotThread polyglotThread = (PolyglotThread)current;
            PolyglotContextImpl context = polyglotThread.context;
            if (context == null && this.activeSingleThread == current) {
                context = polyglotThread.context = this.activeSingleContext;
                this.activeSingleContext = null;
                this.activeSingleContextNonVolatile = null;
                this.activeSingleThread = null;
            }
            return context;
        }
        return super.get();
    }

    @CompilerDirectives.TruffleBoundary
    private PolyglotContextImpl setTLReturnParent(PolyglotContextImpl context) {
        Thread current = Thread.currentThread();
        if (current instanceof PolyglotThread) {
            PolyglotThread polyglotThread = (PolyglotThread)current;
            PolyglotContextImpl prev = polyglotThread.context;
            polyglotThread.context = context;
            return prev;
        }
        Object prev = super.get();
        super.set(context);
        return (PolyglotContextImpl)prev;
    }

    private synchronized PolyglotContextImpl setReturnParentSlowPath(PolyglotContextImpl context) {
        if (!this.singleThread.isValid()) {
            return this.setTLReturnParent(context);
        }
        Thread currentThread = Thread.currentThread();
        Thread storeThread = this.activeSingleThread;
        PolyglotContextImpl prev = this.activeSingleContext;
        if (currentThread == storeThread) {
            this.activeSingleContext = context;
            this.activeSingleContextNonVolatile = context;
        } else if (storeThread == null) {
            this.activeSingleThread = currentThread;
            this.activeSingleContext = context;
            this.activeSingleContextNonVolatile = context;
        } else {
            this.singleThread.invalidate();
            return this.setTLReturnParent(context);
        }
        return prev;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

