/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.exp;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.table.io.exp.GraphTableBuilder;
import com.paterva.maltego.graph.table.io.exp.TabularGraphExportResult;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EntityPairTableBuilder
extends GraphTableBuilder {
    private static final Comparator<List<String>> PAIR_COMPARATOR = (left, right) -> {
        if (left.size() < right.size()) {
            return 1;
        }
        if (left.size() > right.size()) {
            return -1;
        }
        if (left.isEmpty()) {
            return 0;
        }
        int compare = 0;
        int size = left.size();
        for (int index = 0; index < size; ++index) {
            compare = ((String)left.get(index)).compareToIgnoreCase((String)right.get(index));
            if (compare == 0) continue;
            return compare;
        }
        return compare;
    };

    @Override
    protected TabularGraphExportResult build(Set<EntityID> entities, Set<LinkID> links, List<List<String>> table) throws Exception {
        TabularGraphExportResult result = new TabularGraphExportResult();
        int entityTotal = entities.size();
        int linkTotal = links.size();
        HashSet<String> rowKeys = new HashSet<String>(entities.size());
        for (LinkID linkID : links) {
            if (this.distinct) {
                boolean duplicate;
                EntityID sourceID = this.getSourceID(linkID);
                EntityID targetID = this.getTargetID(linkID);
                boolean bl = duplicate = !rowKeys.add(sourceID.toString() + "~" + targetID.toString());
                if (duplicate) {
                    result.setDuplicatesRemoved(result.getDuplicatesRemoved() + 1);
                    continue;
                }
            }
            MaltegoEntity sourceEntity = this.getSourceEntity(linkID);
            MaltegoEntity targetEntity = this.getTargetEntity(linkID);
            String sourceValue = InheritanceHelper.getValueString((SpecRegistry)this.entityRegistry, (TypedPropertyBag)sourceEntity);
            String targetValue = InheritanceHelper.getValueString((SpecRegistry)this.entityRegistry, (TypedPropertyBag)targetEntity);
            List<String> row = Arrays.asList(sourceValue, targetValue);
            table.add(row);
            entities.remove(sourceEntity.getID());
            entities.remove(targetEntity.getID());
        }
        for (EntityID entityID : entities) {
            MaltegoEntity entity = this.getEntity(entityID);
            String entityValue = InheritanceHelper.getValueString((SpecRegistry)this.entityRegistry, (TypedPropertyBag)entity);
            List<String> row = Arrays.asList(entityValue);
            table.add(row);
        }
        this.progressUpdate("Sorting rows...");
        table.sort(PAIR_COMPARATOR);
        List<String> header = Arrays.asList("Source Entity", "Target Entity");
        table.add(0, header);
        result.setEntitiesExported(entityTotal);
        result.setLinksExported(linkTotal);
        result.setLinesGenerated(table.size());
        return result;
    }
}

