.PS
cct_init
# Windings.m4
  ifelse(xtract(m4postprocessor,pstricks,pgf,mpost,pdf,postscript,svg),,
  `print "
    `pstricks, pgf, mpost, pdf, postscript, or svg required for Windings.m4'"',
 ` s_init(Windings)
  ifdef(`Windings_1',,`sinclude(FWindings.dim)')
  sinclude(Circuit_macros.dim)
  ifdef(`Windings_1',,`sinclude(tst.dim)')

Toprow:[
W1: [ W: winding ]
  s_box(\tt w{}inding) at last [].s below

W2: [ winding(R) ] with .n at last "".s+(0,-0.1)
  s_box(\tt w{}inding(R)) at last [].s below

W3: [ sk = 0.75
  d = 1.5*sk
  p = 0.4*sk
  w = 1*sk

define vlight {rgbstring(0.9,0.9,0.9)}
W: winding(L,d,p,4,w,vlight)
  
thinlines_
  dimension_(from W.nw+(p/4,0) right p,0.1,s_box(\tt pitch\strut) above,W)
  dimension_(from W.sw to W.nw,0.2,s_box(\tt diam),H)
  dimension_(from W.e+(-p/2,-w/2) up w,-0.3,,s_ht)
  s_box(\tt\hfill core wid) at W.e ljust
  arrow <- up d-w+0.1 left d/10 from W.ne+(-p/2,-(d-w))
  s_box(\tt core color) at Here+(-0.2,0) ljust above
thicklines_
] with .sw at last [].se+(0.25,0)
  "\tt T1" at last [].W.T1 below
  "\tt T2" at last [].W.T2 below

W4: [
boxwid = 0.3
boxht = 0.4
 down_
B1: box
 winding(,boxwid*1.3,boxht/5,3,boxwid) at B1
  "Left pins" "cw" at B1.s+(0,-0.15)
  for_(1,2,1,`"\sl\small T`'m4x" at last [].T`'m4x rjust')
B2: box at B1.e + (0.5,0)
 winding(R,boxwid*1.3,boxht/5,3,boxwid) at B2
  "Left pins" "ccw" at B2.s+(0,-0.15)
  for_(1,2,1,`"\sl\small T`'m4x" at last [].T`'m4x rjust')
 up_
B3: box at B1.s + (0,-0.55)
 winding(,boxwid*1.3,boxht/5,3,boxwid) at B3
  "Right pins" "cw" at B3.s+(0,-0.15)
  for_(1,2,1,`"\sl\small T`'m4x" at last [].T`'m4x ljust')
B4: box at (B2,B3)
 winding(R,boxwid*1.3,boxht/5,3,boxwid) at B4
  "Right pins" "ccw" at B4.s+(0,-0.15)
  for_(1,2,1,`"\sl\small T`'m4x" at last [].T`'m4x ljust')
] with .sw at last [].se+(0.1,0)


W5: [
 W: arcwinding(,60,120)
  {`"\tt arcwinding("' at W.s+(0,-12bp__) `"\tt ,60,120)"' }
 W: arcwinding(,120,60) with .sw at W.se+(0.4,0)
  {`"\tt $\ldots$(,120,60)"' at last [].s below}
 W: arcwinding(,60,120,,-dimen_) with .nw at 2nd last [].sw+(0,-0.4)
  {`"\tt $\ldots$(,60,120,,"' at W.s+(0,-12bp__) `"\tt -dimen\_)"' }
 W: arcwinding(,120,60,,-dimen_) with .sw at W.se+(0.4,0)
  {`"\tt $\ldots$(,120,60,,"' at W.s+(0,-12bp__) `"\tt -dimen\_)"' }
] with .nw at last [].ne+(0.3,0)

] # end Toprow

Trans:[
  Q: box invis ht 1 wid 5/4
  g = Q.wid/12
  ironwid = Q.wid/4.5

  line thick ironwid/(1bp__)+linethick from Q.n+(g/2-linethick/2 bp__,0) \
    to Q.ne then to Q.se then to Q.sw then to Q.nw \
    then to Q.n+(-g/2+linethick/2 bp__,0)
  ifmpost(`rgbdraw(0.7,0.7,0.7,')
  line thick ironwid/(1bp__)-linethick outlined "lightgray" \
    from Q.n+(g/2+linethick/2 bp__,0) \
    to Q.ne then to Q.se then to Q.sw then to Q.nw \
    then to Q.n+(-g/2-linethick/2 bp__,0)
  ifmpost(`)')

thinlines_
  dimension_(from Q.n+(-g/2,-ironwid/2) right g,-ironwid/4,
    "$g$" below,1,2pt__)
thicklines_

  down_
  P: winding(R,ironwid*5/4,ironwid/2,4,ironwid,"lightgray") at Q.w
    line left ironwid*2/3 from P.T1
    arrow right to P.T1 "$i_1$" above
    line left ironwid*2/3 from P.T2
    gap(up_ to 2nd last line.end)
    llabel(-,s_box($v_1$),+)
    "$N_1$" at P.e ljust

  up_
  S: winding(L,ironwid*5/4,ironwid/2,4,ironwid,"lightgray") at Q.e
    line right ironwid*2/3 from S.T2
    arrow left to S.T2 "$i_2$" above
    line right ironwid*2/3 from S.T1
    gap(up_ to 2nd last line.end)
    rlabel(-,s_box($v_2$),+)
    "$N_2$" at S.w rjust

  box dashed rad ironwid/4 wid Q.wid ht Q.ht at Q
  arrow right arrowht from 0.5 between Q.n and Q.ne
  "$\phi$" ljust at Here+(0,5pt__)

  move up ironwid/2 from Q.n
  move down ironwid/2 from Q.s
] with .nw at Toprow.sw+(0,-0.2) # end Trans

[
#Torus: circle rad 0.6; circle rad 0.4 at Torus
 r_ctr = 0.5
 t_th = 0.2
 w_th = 0.3
 Torus: circle rad r_ctr thick t_th/(1bp__)
  {circle rad r_ctr thick Torus.thick-2*linethick outlined "lightgray" at Torus}

 TN: arcwinding(w_th,110,70,5, r_ctr,t_th,"lightgray") with .C at Torus
   "\sl T1" at TN.T1 below; "\sl T2" at TN.T2 below
 TW: arcwinding(w_th,160,200,4,-r_ctr,t_th,"lightgray") with .C at Torus
   "\sl T1" at TW.T1 above; "\sl T2" at TW.T2 below
 TE: arcwinding(w_th,20,-20,7,-r_ctr,t_th,"lightgray") with .C at Torus
   "\sl T1" at TE.T1 above; "\sl T2" at TE.T2 below
  ] with .nw at last [].ne+(0.15,0) 

')
.PE
