/*
 * Copyright (c) 1997-2002 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "kcm_locl.h"

RCSID("$Id$");

krb5_context kcm_context = NULL;
extern const char *socket_path;

const char *service_name = "org.h5l.kcm";

static RETSIGTYPE
sigusr1(int sig)
{
    kcm_debug_ccache(kcm_context);
}

static RETSIGTYPE
sigusr2(int sig)
{
    kcm_debug_events(kcm_context);
}

int
main(int argc, char **argv)
{
    krb5_error_code ret;
    setprogname(argv[0]);

    ret = krb5_init_context(&kcm_context);
    if (ret) {
	errx (1, "krb5_init_context failed: %d", ret);
	return ret;
    }

    kcm_configure(argc, argv);

#ifdef HAVE_SIGACTION
    {
	struct sigaction sa;

	sa.sa_flags = 0;
	sa.sa_handler = sigusr1;
	sigemptyset(&sa.sa_mask);

	sigaction(SIGUSR1, &sa, NULL);

	sa.sa_handler = sigusr2;
	sigaction(SIGUSR2, &sa, NULL);

	sa.sa_handler = SIG_IGN;
	sigaction(SIGPIPE, &sa, NULL);
    }
#else
    signal(SIGUSR1, sigusr1);
    signal(SIGUSR2, sigusr2);
    signal(SIGPIPE, SIG_IGN);
#endif
    if (detach_from_console && !launchd_flag && daemon_child == -1)
        daemon_child = roken_detach_prep(argc, argv, "--daemon-child");
    rk_pidfile(NULL);

    if (socket_path)
        setenv("HEIM_IPC_DIR", socket_path, 1);

    if (launchd_flag) {
	heim_sipc mach;
	ret = heim_sipc_launchd_mach_init(service_name, kcm_service, NULL, &mach);
        if (ret)
            krb5_err(kcm_context, 1, ret, "Could not setup launchd service");
    } else {
	heim_sipc un;
	ret = heim_sipc_service_unix(service_name, kcm_service, NULL, &un);
        if (ret)
            krb5_err(kcm_context, 1, ret, "Could not setup Unix domain socket service");
    }
#ifdef HAVE_DOOR_CREATE
    {
	heim_sipc door;
	ret = heim_sipc_service_door(service_name, kcm_service, NULL, &door);
        if (ret)
            krb5_err(kcm_context, 1, ret, "Could not setup door service");
    }
#endif

    roken_detach_finish(NULL, daemon_child);

    heim_ipc_main();

    krb5_free_context(kcm_context);
    return 0;
}
