# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicesdatareplication import RecoveryServicesDataReplicationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRecoveryServicesDataReplicationMgmtProtectedItemOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RecoveryServicesDataReplicationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_protected_item_get(self, resource_group):
        response = self.client.protected_item.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            protected_item_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_protected_item_begin_create(self, resource_group):
        response = self.client.protected_item.begin_create(
            resource_group_name=resource_group.name,
            vault_name="str",
            protected_item_name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "customProperties": "protected_item_model_custom_properties",
                    "policyName": "str",
                    "replicationExtensionName": "str",
                    "allowedJobs": ["str"],
                    "correlationId": "str",
                    "currentJob": {
                        "displayName": "str",
                        "endTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "scenarioName": "str",
                        "startTime": "2020-02-20 00:00:00",
                        "state": "str",
                    },
                    "fabricAgentId": "str",
                    "fabricId": "str",
                    "fabricObjectId": "str",
                    "fabricObjectName": "str",
                    "healthErrors": [
                        {
                            "affectedResourceCorrelationIds": ["str"],
                            "affectedResourceType": "str",
                            "category": "str",
                            "causes": "str",
                            "childErrors": [
                                {
                                    "category": "str",
                                    "causes": "str",
                                    "code": "str",
                                    "creationTime": "2020-02-20 00:00:00",
                                    "healthCategory": "str",
                                    "isCustomerResolvable": bool,
                                    "message": "str",
                                    "recommendation": "str",
                                    "severity": "str",
                                    "source": "str",
                                    "summary": "str",
                                }
                            ],
                            "code": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "healthCategory": "str",
                            "isCustomerResolvable": bool,
                            "message": "str",
                            "recommendation": "str",
                            "severity": "str",
                            "source": "str",
                            "summary": "str",
                        }
                    ],
                    "lastFailedEnableProtectionJob": {
                        "displayName": "str",
                        "endTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "scenarioName": "str",
                        "startTime": "2020-02-20 00:00:00",
                        "state": "str",
                    },
                    "lastFailedPlannedFailoverJob": {
                        "displayName": "str",
                        "endTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "scenarioName": "str",
                        "startTime": "2020-02-20 00:00:00",
                        "state": "str",
                    },
                    "lastSuccessfulPlannedFailoverTime": "2020-02-20 00:00:00",
                    "lastSuccessfulTestFailoverTime": "2020-02-20 00:00:00",
                    "lastSuccessfulUnplannedFailoverTime": "2020-02-20 00:00:00",
                    "lastTestFailoverJob": {
                        "displayName": "str",
                        "endTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "scenarioName": "str",
                        "startTime": "2020-02-20 00:00:00",
                        "state": "str",
                    },
                    "protectionState": "str",
                    "protectionStateDescription": "str",
                    "provisioningState": "str",
                    "replicationHealth": "str",
                    "resyncRequired": bool,
                    "resynchronizationState": "str",
                    "sourceFabricProviderId": "str",
                    "targetFabricAgentId": "str",
                    "targetFabricId": "str",
                    "targetFabricProviderId": "str",
                    "testFailoverState": "str",
                    "testFailoverStateDescription": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_protected_item_begin_update(self, resource_group):
        response = self.client.protected_item.begin_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            protected_item_name="str",
            properties={
                "id": "str",
                "name": "str",
                "properties": {"customProperties": "protected_item_model_custom_properties_update"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_protected_item_begin_delete(self, resource_group):
        response = self.client.protected_item.begin_delete(
            resource_group_name=resource_group.name,
            vault_name="str",
            protected_item_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_protected_item_list(self, resource_group):
        response = self.client.protected_item.list(
            resource_group_name=resource_group.name,
            vault_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_protected_item_begin_planned_failover(self, resource_group):
        response = self.client.protected_item.begin_planned_failover(
            resource_group_name=resource_group.name,
            vault_name="str",
            protected_item_name="str",
            body={"properties": {"customProperties": "planned_failover_model_custom_properties"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
